<?php include_once('header.php'); ?>
<div class="container mt-4">
    <h2>Add Audio</h2>
    <?php if (isset($_GET['msg'])): ?>
        <?php if ($_GET['msg'] === 'added'): ?>
            <div class="alert alert-success">Audio file added successfully.</div>
        <?php elseif ($_GET['msg'] === 'upload_error'): ?>
            <div class="alert alert-danger">There was an error uploading the audio file.</div>
        <?php elseif ($_GET['msg'] === 'invalid_file'): ?>
            <div class="alert alert-warning">Invalid file type. Only mp3, wav, and ogg files are allowed.</div>
        <?php elseif ($_GET['msg'] === 'error'): ?>
            <div class="alert alert-danger">An error occurred. Please try again.</div>
        <?php endif; ?>
    <?php endif; ?>
    <form action="sql_statements.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="create_audio" value="1">
        <div class="form-group">
            <label>Title</label>
            <input type="text" name="title" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Description</label>
            <textarea name="description" class="form-control"></textarea>
        </div>
        <div class="form-group">
            <label>Category</label>
            <select name="category" class="form-control" required>
                <option value="">Select Category</option>
                <?php
                // Fetch categories from audio_categories table
                $categories = $con->getRows('audio_categories', array('order_by'=>'name ASC'));
                foreach ($categories as $cat): ?>
                    <option value="<?php echo $cat['id']; ?>"><?php echo htmlspecialchars($cat['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Audio File</label>
            <input type="file" name="audio" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-success">Add Audio</button>
    </form>
</div>
<?php include_once('footer.php'); ?> 