<?php include_once('header.php'); ?>
<div class="container mt-4">
    <h2>Audios Management</h2>
    <a href="audios_add.php" class="btn btn-primary mb-3">Add New Audio</a>
    <?php if (isset($_GET['msg'])): ?>
        <?php if ($_GET['msg'] === 'added'): ?>
            <div class="alert alert-success">Audio file added successfully.</div>
        <?php elseif ($_GET['msg'] === 'deleted'): ?>
            <div class="alert alert-success">Audio file deleted successfully.</div>
        <?php elseif ($_GET['msg'] === 'invalid_file'): ?>
            <div class="alert alert-warning">Invalid file type. Only mp3, wav, and ogg files are allowed.</div>
        <?php elseif ($_GET['msg'] === 'error'): ?>
            <div class="alert alert-danger">An error occurred. Please try again.</div>
        <?php endif; ?>
    <?php endif; ?>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Title</th>
                <th>Description</th>
                <th>Category</th>
                <th>File</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Fetch audios from DB
            $audios = $con->getRows('audio_files', array('order_by'=>'created_at DESC'));
            // Fetch all audio categories and build an id=>name map
            $cat_map = array();
            $categories = $con->getRows('audio_categories', array('order_by'=>'name ASC'));
            if ($categories && is_array($categories)) {
                foreach ($categories as $cat) {
                    $cat_map[$cat['id']] = $cat['name'];
                }
            }
            if ($audios && is_array($audios) && count($audios) > 0):
                foreach ($audios as $audio):
            ?>
            <tr>
                <td><?php echo $audio['title']; ?></td>
                <td><?php echo $audio['description']; ?></td>
                <td><?php echo isset($cat_map[$audio['category_id']]) ? htmlspecialchars($cat_map[$audio['category_id']]) : 'Uncategorized'; ?></td>
                <td><a href="../../../assets/uploads/audios/<?php echo $audio['file_path']; ?>" target="_blank">Download</a></td>
                <td>
                    <a href="audios_edit.php?id=<?php echo $audio['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                    <form action="sql_statements.php" method="POST" style="display:inline;">
                        <input type="hidden" name="action" value="delete_audio">
                        <input type="hidden" name="id" value="<?php echo $audio['id']; ?>">
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this audio?')">Delete</button>
                    </form>
                </td>
            </tr>
            <?php
                endforeach;
            else:
            ?>
            <tr>
                <td colspan="5" class="text-center">No audios found.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php include_once('footer.php'); ?> 