<?php include_once('header.php'); ?>
<div class="container mt-4">
    <h2>Add Gallery Image</h2>
    <form action="sql_statements.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="create_gallery" value="1">
        <div class="form-group">
            <label>Title</label>
            <input type="text" name="title" class="form-control" required>
        </div>
        <div class="form-group">
            <label>Description</label>
            <input type="text" name="description" class="form-control">
        </div>
        <div class="form-group">
            <label>Category</label>
            <select name="category" class="form-control" required>
                <option value="">Select Category</option>
                <?php
                // Fetch categories from gallery_categories table
                $categories = $con->getRows('gallery_categories', array('order_by'=>'name ASC'));
                foreach ($categories as $cat): ?>
                    <option value="<?php echo $cat['id']; ?>"><?php echo htmlspecialchars($cat['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Image File</label>
            <input type="file" name="image" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-success" name="create_gallery" >Add Image</button>
    </form>
</div>
<?php include_once('footer.php'); ?> 