<?php include_once('header.php'); ?>
<div class="container mt-4">
    <h2>Gallery Management</h2>
    <a href="gallery_add.php" class="btn btn-primary mb-3">Add New Image</a>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Image</th>
                <th>Title</th>
                <th>Description</th>
                <th>Category</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Fetch gallery images from DB
            $images = $con->getRows('gallery_images', array('order_by'=>'created_at DESC'));
            // Fetch all categories and build an id=>name map
            $cat_map = array();
            $categories = $con->getRows('gallery_categories', array('order_by'=>'name ASC'));
            if ($categories && is_array($categories)) {
                foreach ($categories as $cat) {
                    $cat_map[$cat['id']] = $cat['name'];
                }
            }
            if ($images && is_array($images) && count($images) > 0):
                foreach ($images as $image):
            ?>
            
            <tr>
                <td><img src="../../../assets/uploads/gallery/<?php echo $image['image_path']; ?>" width="80"></td>
                <td><?php echo $image['title']; ?></td>
                <td><?php echo $image['description']; ?></td>
                <td><?php echo isset($cat_map[$image['category_id']]) ? htmlspecialchars($cat_map[$image['category_id']]) : 'Uncategorized'; ?></td>
                <td>
                    <a href="gallery_edit.php?id=<?php echo $image['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                    <form action="sql_statements.php" method="POST" style="display:inline;">
                        <input type="hidden" name="action" value="delete_gallery">
                        <input type="hidden" name="id" value="<?php echo $image['id']; ?>">
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this image?')">Delete</button>
                    </form>
                </td>
            </tr>
            
            <?php
               endforeach;
           else:
           ?>
           <tr>
               <td colspan="5" class="text-center">No images found.</td>
           </tr>
           <?php endif; ?>
        </tbody>
    </table>
</div>
<?php include_once('footer.php'); ?> 