<?php
include_once('header.php');
// Fetch the image details from DB using $_GET['id']
$image = $con->getRows('gallery_images', array('where' => 'id="'.intval($_GET['id']).'"', 'return_type' => 'single'));
?>
<div class="container mt-4">
    <h2>Edit Gallery Image</h2>
    <form action="sql_statements.php" method="POST" enctype="multipart/form-data">
        <input type="hidden" name="update_gallery" value="1">
        <input type="hidden" name="id" value="<?php echo $image['id']; ?>">
        <div class="form-group">
            <label>Title</label>
            <input type="text" name="title" class="form-control" value="<?php echo $image['title']; ?>" required>
        </div>
        <div class="form-group">
            <label>Description</label>
            <input type="text" name="description" class="form-control" value="<?php echo $image['description']; ?>">
        </div>
        <div class="form-group">
            <label>Category</label>
            <select name="category" class="form-control" required>
                <option value="">Select Category</option>
                <?php
                // Fetch categories from gallery_categories table
                $categories = $con->getRows('gallery_categories', array('order_by'=>'name ASC'));
                foreach ($categories as $cat): ?>
                    <option value="<?php echo $cat['id']; ?>" <?php if(isset($image['category_id']) && $image['category_id'] == $cat['id']) echo 'selected'; ?>><?php echo htmlspecialchars($cat['name']); ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="form-group">
            <label>Change Image (optional)</label>
            <input type="file" name="image" class="form-control">
        </div>
        <button type="submit" class="btn btn-success">Update Image</button>
    </form>
</div>
<?php include_once('footer.php'); ?> 