<?php include_once('header.php'); ?>
<div class="container mt-4">
    <h2>Videos Management</h2>
    <a href="videos_add.php" class="btn btn-primary mb-3">Add New Video</a>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>Title</th>
                <th>Description</th>
                <th>Video File</th>
                <th>Category</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php
            // Fetch videos from DB
            $videos = $con->getRows('videos', array('order_by'=>'created_at DESC'));
            // Fetch all video categories and build an id=>name map
            $cat_map = array();
            $categories = $con->getRows('video_categories', array('order_by'=>'name ASC'));
            if ($categories && is_array($categories)) {
                foreach ($categories as $cat) {
                    $cat_map[$cat['id']] = $cat['name'];
                }
            }
            if ($videos && is_array($videos) && count($videos) > 0):
                foreach ($videos as $video):
            ?>
            <tr>
                <td><?php echo $video['title']; ?></td>
                <td><?php echo $video['description']; ?></td>
                <td>
                    <?php if (!empty($video['file_path'])): ?>
                        <a href="../../../assets/uploads/videos/<?php echo $video['file_path']; ?>" target="_blank">Download</a>
                    <?php else: ?>
                        No video file
                    <?php endif; ?>
                </td>
                <td><?php echo isset($cat_map[$video['category_id']]) ? htmlspecialchars($cat_map[$video['category_id']]) : 'Uncategorized'; ?></td>
                <td>
                    <a href="videos_edit.php?id=<?php echo $video['id']; ?>" class="btn btn-sm btn-warning">Edit</a>
                    <form action="sql_statements.php" method="POST" style="display:inline;">
                        <input type="hidden" name="action" value="delete_video">
                        <input type="hidden" name="id" value="<?php echo $video['id']; ?>">
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Delete this video?')">Delete</button>
                    </form>
                </td>
            </tr>
            <?php
                endforeach;
            else:
            ?>
            <tr>
                <td colspan="5" class="text-center">No videos found.</td>
            </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
<?php include_once('footer.php'); ?> 