<?php include_once('layout/header.php'); ?>
    <section class="page-header">
        <div class="container">
            <h1 class="heading">Audio Resources</h1>
            <ul class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item active"><a href="#">Audio Resources</a></li>
            </ul>
        </div>
    </section>

    <section class="mt-100 mb-100">
        <div class="container">
            <div class="row">
                <div class="col-lg-9">
                    <div class="row">
                        <?php
                        $con = new DB;
                        $audios = $con->getRows('audio_files', array('order_by'=>'created_at DESC'));
                        if ($audios && is_array($audios) && count($audios) > 0):
                            foreach ($audios as $audio):
                        ?>
                        <div class="col-md-6 mb-4">
                            <div class="card">
                                <div class="card-body">
                                    <h5 class="card-title"><?php echo htmlspecialchars($audio['title']); ?></h5>
                                    <p class="card-text"><?php echo htmlspecialchars($audio['description']); ?></p>
                                    <audio controls class="w-100 mt-3">
                                        <source src="assets/uploads/audios/<?php echo $audio['file_path']; ?>" type="audio/mpeg">
                                        Your browser does not support the audio element.
                                    </audio>
                                </div>
                            </div>
                        </div>
                        <?php
                            endforeach;
                        else:
                        ?>
                        <div class="col-12 text-center">
                            <p>No audio resources found.</p>
                        </div>
                        <?php endif; ?>
                    </div>
                    <!-- Pagination (optional, not implemented here) -->
                </div>
                <div class="col-lg-3">
                    <aside class="card widget search-widget">
                        <div class="card-body">
                            <h5 class="heading">Search Audio</h5>
                            <form class="search form-inline">
                                <div class="input-group">
                                    <input type="text" class="form-control" placeholder="Search">
                                    <span class="input-group-btn">
                                        <button class="btn btn-light" type="button"><i class="fa fa-search fa-fw"></i></button>
                                    </span>
                                </div>
                            </form>              
                        </div>  
                    </aside>
                    <aside class="card widget category-widget">
                        <div class="card-body">
                            <h5 class="heading">Audio Categories</h5>
                            <ul class="categories">
                                <?php
                                $categories = $con->getRows('audio_categories', array('order_by'=>'name ASC'));
                                if ($categories && is_array($categories)) {
                                    foreach ($categories as $cat) {
                                        echo '<li><a href="#">' . htmlspecialchars($cat['name']) . '</a></li>';
                                    }
                                }
                                ?>
                            </ul>
                        </div>
                    </aside>
                    <aside class="card card-no-border widget download-widget text-center">
                        <img src="images/download.jpg" class="card-img" alt="">
                        <div class="card-img-overlay d-flex flex-column justify-content-center">
                            <p class="text-white font24">Download our audio resources</p>
                        </div>
                    </aside>
                </div>
            </div>
        </div>
    </section>

<?php include_once('layout/footer.php'); ?>