<?php include_once('layout/header.php'); ?>

    <section class="page-header">
        <div class="container">
            <h1 class="heading">Jobs</h1>
            <ul class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active"><a href="#">Jobs</a></li>
            </ul>
        </div>
    </section>

    <section class="mt-100 mb-100">
        <div class="container">			
            <div class="row">
			<?php
                    $posts = $con->getRows('vacancies a, job_categories b', array('where' => 'a.status=1 and a.job_category=b.category_id', 'order_by' => 'date_posted desc'));
                    if (!empty($posts)) {
                        foreach ($posts as $post) { ?>

                <div class="col-lg-8">
                    <div class="card">
                        <div class="card-header d-flex align-items-center justify-content-between">
                            <h4 class="nom"><?= $post['job_title'] ?></h4>
                            <a href="vacancy-details.php?vacancy_id=<?= $post['vacancy_id'] ?>" class="btn btn-primary btn-sm float-right">View Details</a>
                        </div>
                        <ul class="list-group list-group-flush">
						<li class="list-group-item"><strong>Job Category :</strong> <?= $post['category'] ?></li>
                            <li class="list-group-item"><strong>Date posted :</strong> <?= $post['date_posted'] ?></li>
                            <li class="list-group-item"><strong>Closing date :</strong> <?= $post['closing_date']?></li>
                            <li class="list-group-item"> <p><?= substr(strip_tags($post['job_description']), 0, 200); ?>...</p></li>
                        </ul>
						
                    </div>
                    
                    
                </div>
				
			<?php    }
                    } else { ?>
                        <div class="post-card">
                            <div class="post-content-wrap">
                                <ul class="post-meta">
                                    <div class="post-content">
                                        <div class="alert alert-warning"> <button type="button" class="close" data-dismiss="alert"></button>&nbsp; There are no open vacancies currently, please come and check later.</div>
                                    </div>
                            </div>
                        </div>
                    <?php } ?>
			
                
            </div>
			
			
			
        </div>
		
		
    </section>
	
<?php include_once('layout/footer.php'); ?>