<?php include_once('layout/header.php'); ?>

    <section class="page-header">
        <div class="container">
            <h1 class="heading">Trustee Profile</h1>
            <ul class="breadcrumb">
                <li class="breadcrumb-item"><a href="index.php">Home</a></li>
                <li class="breadcrumb-item"><a href="trustees.php">Trustees</a></li>
                <li class="breadcrumb-item active"><a href="#">Profile</a></li>
            </ul>
        </div>
    </section>

    <section class="container mt-100 mb-100">
        <?php
        if (isset($_GET['id']) && !empty($_GET['id'])) {
            $leader_id = intval($_GET['id']);
            $member = $con->getRows('leadership', array('where' => 'leader_id=' . $leader_id, 'return_type' => 'single'));

            if (!empty($member)) {
        ?>
        <div class="row">
            <!-- Profile Image and Social Links -->
            <div class="col-lg-4">
                <div class="card">
                    <div class="card-body text-center">
                        <img src="assets/uploads/leadership/<?=$member['image']?>" class="img-fluid rounded mb-3" alt="<?=$member['name']?>" style="max-width: 100%; height: auto;">
                        <h4 class="heading"><?=$member['name']?></h4>
                        <p class="text-muted"><strong><?=$member['title']?></strong></p>
                        
                        <!-- Social Links -->
                        <div class="mt-4">
                            <ul class="list-unstyled d-flex justify-content-center gap-3">
                                <?php if (!empty($member['facebook'])): ?>
                                    <li><a href="<?=$member['facebook']?>" target="_blank" class="btn btn-sm btn-outline-primary"><i class="fa fa-facebook"></i></a></li>
                                <?php endif; ?>
                                <?php if (!empty($member['twitter'])): ?>
                                    <li><a href="<?=$member['twitter']?>" target="_blank" class="btn btn-sm btn-outline-primary"><i class="fa fa-twitter"></i></a></li>
                                <?php endif; ?>
                                <?php if (!empty($member['linkedin'])): ?>
                                    <li><a href="<?=$member['linkedin']?>" target="_blank" class="btn btn-sm btn-outline-primary"><i class="fa fa-linkedin"></i></a></li>
                                <?php endif; ?>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Profile Details -->
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-body">
                        <h3 class="heading mb-4">About <?=$member['name']?></h3>
                        
                        <!-- Biography -->
                        <div class="mb-4">
                            <h5 class="heading">Biography</h5>
                            <p><?=htmlspecialchars($member['biography'] ?? 'No biography available')?></p>
                        </div>

                        <!-- Information Table -->
                        <div class="mb-4">
                            <h5 class="heading">Information</h5>
                            <table class="table table-bordered">
                                <tr>
                                    <td><strong>Name</strong></td>
                                    <td><?=$member['name']?></td>
                                </tr>
                                <tr>
                                    <td><strong>Title</strong></td>
                                    <td><?=$member['title']?></td>
                                </tr>
                            </table>
                        </div>

                        <!-- Back Button -->
                        <div>
                            <a href="trustees.php" class="btn btn-primary">Back to Trustees</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <?php
            } else {
        ?>
        <div class="alert alert-danger" role="alert">
            <h4 class="alert-heading">Trustee Not Found</h4>
            <p>The trustee profile you're looking for doesn't exist.</p>
            <a href="trustees.php" class="btn btn-primary">Back to Trustees</a>
        </div>
        <?php
            }
        } else {
        ?>
        <div class="alert alert-warning" role="alert">
            <h4 class="alert-heading">Invalid Request</h4>
            <p>No trustee ID provided.</p>
            <a href="trustees.php" class="btn btn-primary">Back to Trustees</a>
        </div>
        <?php
        }
        ?>
    </section>

    <?php include_once('layout/footer.php'); ?>
