<?php include_once('layout/header.php'); ?>
<section class="page-header">
    <div class="container">
        <h1 class="heading">Videos</h1>
        <ul class="breadcrumb">
            <li class="breadcrumb-item"><a href="index.php">Home</a></li>
            <li class="breadcrumb-item active"><a href="#">Videos</a></li>
        </ul>
    </div>
</section>

<section class="mt-100 mb-100">
    <div class="container">
        <div class="row">
            <div class="col-lg-9">
                <div class="row">
                    <?php
                    $videos = $con->getRows('videos', array('order_by'=>'created_at DESC'));
                    if ($videos && is_array($videos) && count($videos) > 0):
                        foreach ($videos as $video):
                    ?>
                    <div class="col-md-6 mb-4">
                        <div class="card">
                            <div class="embed-responsive embed-responsive-16by9">
                                <video class="embed-responsive-item" controls>
                                    <source src="assets/uploads/videos/<?php echo $video['file_path']; ?>" type="video/mp4">
                                    Your browser does not support the video tag.
                                </video>
                            </div>
                            <div class="card-body">
                                <h5 class="card-title"><?php echo htmlspecialchars($video['title']); ?></h5>
                                <p class="card-text"><?php echo htmlspecialchars($video['description']); ?></p>
                            </div>
                        </div>
                    </div>
                    <?php
                        endforeach;
                    else:
                    ?>
                    <div class="col-12 text-center">
                        <p>No videos found.</p>
                    </div>
                    <?php endif; ?>
                </div>
                <!-- Pagination (optional, not implemented here) -->
            </div>
            <div class="col-lg-3">
                <aside class="card widget search-widget">
                    <div class="card-body">
                        <h5 class="heading">Search Videos</h5>
                        <form class="search form-inline">
                            <div class="input-group">
                                <input type="text" class="form-control" placeholder="Search">
                                <span class="input-group-btn">
                                    <button class="btn btn-light" type="button"><i class="fa fa-search fa-fw"></i></button>
                                </span>
                            </div>
                        </form>              
                    </div>  
                </aside>
                <aside class="card widget category-widget">
                    <div class="card-body">
                        <h5 class="heading">Video Categories</h5>
                        <ul class="categories">
                            <?php
                            $categories = $con->getRows('video_categories', array('order_by'=>'name ASC'));
                            if ($categories && is_array($categories)) {
                                foreach ($categories as $cat) {
                                    echo '<li><a href="#">' . htmlspecialchars($cat['name']) . '</a></li>';
                                }
                            }
                            ?>
                        </ul>
                    </div>
                </aside>
                <aside class="card card-no-border widget download-widget text-center">
                    <img src="images/download.jpg" class="card-img" alt="">
                    <div class="card-img-overlay d-flex flex-column justify-content-center">
                        <p class="text-white font24">Subscribe to our YouTube channel</p>
                    </div>
                </aside>
            </div>
        </div>
    </div>
</section>
<?php include_once('layout/footer.php'); ?>