﻿-- database backup - 2026-02-07 13:04:02
SET NAMES utf8;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';
SET foreign_key_checks = 0;
SET AUTOCOMMIT = 0;
START TRANSACTION;
DROP TABLE IF EXISTS `advance_payments`;

CREATE TABLE `advance_payments` (
  `payment_id` int(11) NOT NULL AUTO_INCREMENT,
  `advance_id` int(11) NOT NULL,
  `amount_paid` double NOT NULL,
  `date_paid` date NOT NULL,
  `recorded_by` varchar(60) NOT NULL,
  PRIMARY KEY (`payment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
DROP TABLE IF EXISTS `advance_requests`;

CREATE TABLE `advance_requests` (
  `advance_id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_by` varchar(60) NOT NULL,
  `amount` double NOT NULL,
  `total_paid` double NOT NULL DEFAULT 0,
  `balance` double NOT NULL DEFAULT 0,
  `start` varchar(32) NOT NULL,
  `end` varchar(32) NOT NULL,
  `purpose` text DEFAULT NULL,
  `verified_by` varchar(60) DEFAULT NULL,
  `verified_date` date DEFAULT NULL,
  `verified_comment` text DEFAULT NULL,
  `months` int(11) DEFAULT NULL,
  `monthly_installment` double DEFAULT NULL,
  `supervised_by` varchar(60) DEFAULT NULL,
  `date_supervised` date DEFAULT NULL,
  `supervisor_comment` text DEFAULT NULL,
  `approved_by` varchar(60) DEFAULT NULL,
  `date_approved` date DEFAULT NULL,
  `approval_remark` text DEFAULT NULL,
  `advance_status` int(11) NOT NULL DEFAULT 0,
  `date_posted` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`advance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `advance_requests` VALUES('2','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','450000','0','450000','2024-02','2024-04','House rent','','','','3','150000','','','','','','','0','2024-01-25 06:56:16');
INSERT INTO `advance_requests` VALUES('4','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','100000','0','100000','2026-03','2026-03','ok','','','','1','100000','','','','','','','0','2026-02-04 17:21:10');
INSERT INTO `advance_requests` VALUES('5','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','100000','0','100000','2026-03','2026-05','ok','','','','3','33333.333333333','','','','','','','0','2026-02-04 17:23:48');
INSERT INTO `advance_requests` VALUES('6','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','200000','0','200000','2026-11','2026-12','pliz asist','','','','2','100000','','','','','','','0','2026-02-04 17:25:27');
INSERT INTO `advance_requests` VALUES('7','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','200000','0','200000','2026-11','2026-12','pliz asist','','','','2','100000','','','','','','','0','2026-02-04 17:25:48');
INSERT INTO `advance_requests` VALUES('8','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','400000','0','400000','2026-03','2026-03','ok','','','','1','400000','','','','','','','0','2026-02-04 17:27:55');
INSERT INTO `advance_requests` VALUES('9','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','500000','0','500000','2026-03','2026-04','ok','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-05','ok','2','250000','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-05','ok','','','','3','2026-02-04 17:29:24');
INSERT INTO `advance_requests` VALUES('10','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','90000','0','90000','2026-11','2026-12','OK','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-04','ok','2','45000','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-04','ok','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','2026-02-06','good','4','2026-02-04 17:40:41');
INSERT INTO `advance_requests` VALUES('11','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','67999999','0','67999999','2026-07','2026-07','ok','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-04','Approved he has no any outstanding balance','1','67999999','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-04','ok','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','2026-02-06','go ahead','4','2026-02-04 17:52:45');
INSERT INTO `advance_requests` VALUES('12','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','50000','0','50000','2026-03-01','2026-04-01','School fees','','','','2','25000','','','','','','','0','2026-02-06 11:08:24');
INSERT INTO `advance_requests` VALUES('13','m2qYOyqKVKErImdlwCImuwgg','20000','0','20000','2026-02-20','2026-02-26','ok','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-06','ok','2','10000','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-06','ok','','','','3','2026-02-06 14:22:16');
INSERT INTO `advance_requests` VALUES('14','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','450000','0','450000','2026-03','2026-06','Hospital Bills','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-07','Approved he has no any outstanding balance','4','112500','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-07','Approved he has no any outstanding balance','','','','3','2026-02-07 00:47:20');
DROP TABLE IF EXISTS `band_rates`;

CREATE TABLE `band_rates` (
  `band_id` int(11) NOT NULL AUTO_INCREMENT,
  `band_title` varchar(32) NOT NULL,
  `accomodation_ceiling` double NOT NULL,
  `lumpsum` double NOT NULL,
  `with_accomodation` double NOT NULL,
  `withoutaccomodation_nomeals` double NOT NULL,
  `withoutaccomodation_withmeals` double NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`band_id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `band_rates` VALUES('1','Band1','180000','85000','25000','22500','12500','2023-08-15 06:19:51');
INSERT INTO `band_rates` VALUES('2','Band2','126000','60000','18750','15000','10000','2023-08-15 06:21:22');
INSERT INTO `band_rates` VALUES('3','Band3','72000','50000','15625','12000','7500','2023-08-15 06:22:39');
INSERT INTO `band_rates` VALUES('4','Band4','54000','40000','12500','7500','7500','2023-08-15 06:23:55');
INSERT INTO `band_rates` VALUES('5','Band5','54000','40000','12500','7500','7500','2023-11-05 11:59:35');
INSERT INTO `band_rates` VALUES('7','Band 20','65000','150000','15000','15000','150000','2026-02-06 10:36:46');
DROP TABLE IF EXISTS `branches`;

CREATE TABLE `branches` (
  `branch_id` int(11) NOT NULL AUTO_INCREMENT,
  `branch_name` varchar(32) NOT NULL,
  PRIMARY KEY (`branch_id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `branches` VALUES('2','Lilongwe');
INSERT INTO `branches` VALUES('3','Mzuzu');
INSERT INTO `branches` VALUES('4','Blantyre');
DROP TABLE IF EXISTS `daily_itinerary`;

CREATE TABLE `daily_itinerary` (
  `daily_id` int(11) NOT NULL AUTO_INCREMENT,
  `employee_id` varchar(60) NOT NULL,
  `travel_advance_id` varchar(128) NOT NULL,
  `date` date NOT NULL,
  `place_from` varchar(128) NOT NULL,
  `place_to` varchar(128) NOT NULL,
  PRIMARY KEY (`daily_id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `daily_itinerary` VALUES('1','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1704716776R0fzjrIBKcIt0gJ2DvpVeb95J','2024-01-08','LL','Mzuzu');
INSERT INTO `daily_itinerary` VALUES('2','ZC2UrkGa5cobAdVmgWVPXEDb0th6FlcgV','1704716777mRBd','2024-01-08','Lilongwe','Mzuzu');
INSERT INTO `daily_itinerary` VALUES('4','cN7XJK4EJgIcFZ3P4pL','1704716790qnx5BQnuwyl8889sYuP1hnRAAknW4c','2024-01-08','LL','MZ');
INSERT INTO `daily_itinerary` VALUES('5','QWiEBixN9WstbEGkqEvp','1704716791CgD4nAeS0NVtrHzXO6sw0vaHu4gz2NuS8UjcvciFmmq','2024-01-08','Lilongwe','Thyolo');
INSERT INTO `daily_itinerary` VALUES('6','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','1704716797PjbMqMy5tXeSFbZAvHeNCREDrCvJTllM4n','2024-01-08','Lilongwe','Blantyre');
INSERT INTO `daily_itinerary` VALUES('7','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1704716776R0fzjrIBKcIt0gJ2DvpVeb95J','2024-01-09','Mz','Dwasco');
INSERT INTO `daily_itinerary` VALUES('8','cN7XJK4EJgIcFZ3P4pL','1704716790qnx5BQnuwyl8889sYuP1hnRAAknW4c','2024-01-09','MZ','BT');
INSERT INTO `daily_itinerary` VALUES('10','ZC2UrkGa5cobAdVmgWVPXEDb0th6FlcgV','1704716777mRBd','2024-01-09','Mzuzu','Dwascco');
INSERT INTO `daily_itinerary` VALUES('11','YS3870fdsPY1LhX304','17047168284UoUpF78B5cgVZzw1JrheEEfMwMlel308DUk','2024-01-08','LL','MZ');
INSERT INTO `daily_itinerary` VALUES('12','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1704716776R0fzjrIBKcIt0gJ2DvpVeb95J','2024-01-10','Dwasco','LL');
INSERT INTO `daily_itinerary` VALUES('13','ZC2UrkGa5cobAdVmgWVPXEDb0th6FlcgV','1704716777mRBd','2024-01-10','Dwascco','Lilongwe');
INSERT INTO `daily_itinerary` VALUES('15','QWiEBixN9WstbEGkqEvp','1704716791CgD4nAeS0NVtrHzXO6sw0vaHu4gz2NuS8UjcvciFmmq','2024-01-12','Lilongwe','Salima');
INSERT INTO `daily_itinerary` VALUES('16','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1705912856BOMQD2uVahIaxu4ct0kr4cIlXf2qJF4D7JgotKIl5FjixZs9','2000-01-01','BT','MKaka');
INSERT INTO `daily_itinerary` VALUES('17','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1705912856BOMQD2uVahIaxu4ct0kr4cIlXf2qJF4D7JgotKIl5FjixZs9','2000-01-02','Mkaka','Chikwawa');
INSERT INTO `daily_itinerary` VALUES('18','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1705912856BOMQD2uVahIaxu4ct0kr4cIlXf2qJF4D7JgotKIl5FjixZs9','2000-01-02','Chikwawa','BT');
INSERT INTO `daily_itinerary` VALUES('19','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1706079573CPDQP5T7','2024-01-23','Lilongwe','Blantyre');
INSERT INTO `daily_itinerary` VALUES('20','inAJsQeZy13r6c5xRI8i0','1706085740r49gokzK1gC7ran2lK65zPyQORR255o5j9ZbMvnJuZT22DC2','2024-01-24','mzuzu','blantyre');
INSERT INTO `daily_itinerary` VALUES('21','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','177039529672xPMrexshdiQEchOH8Mw','2026-02-09','Blantyre','Lilongwe');
INSERT INTO `daily_itinerary` VALUES('22','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','177039529672xPMrexshdiQEchOH8Mw','2026-02-18','Lilongwe','Blantyre');
DROP TABLE IF EXISTS `db_backups`;

CREATE TABLE `db_backups` (
  `backup_id` int(11) NOT NULL AUTO_INCREMENT,
  `backedup_by` varchar(60) NOT NULL,
  `file_title` varchar(128) NOT NULL,
  `file_name` varchar(64) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`backup_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `db_backups` VALUES('1','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','backup2','muscco_backup_20231219_212914.sql','2023-12-19 16:29:14');
INSERT INTO `db_backups` VALUES('2','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','StaffPortal12012024','muscco_backup_20240112_071018.sql','2024-01-12 02:10:18');
INSERT INTO `db_backups` VALUES('3','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','MBTS2020','muscco_backup_20260207_130307.sql','2026-02-07 08:03:07');
DROP TABLE IF EXISTS `departments`;

CREATE TABLE `departments` (
  `department_id` int(11) NOT NULL AUTO_INCREMENT,
  `department` varchar(1028) NOT NULL,
  `member_of` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`department_id`)
) ENGINE=InnoDB AUTO_INCREMENT=63 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Stores Sacco and Muscco Departments';
INSERT INTO `departments` VALUES('1','Information Technology Dept','0');
INSERT INTO `departments` VALUES('3','Human Resources &amp; Administration','0');
INSERT INTO `departments` VALUES('4','Finance &amp; CFF','0');
INSERT INTO `departments` VALUES('11','Business Development and Projects','0');
INSERT INTO `departments` VALUES('20','Audit &amp; Risk Management','0');
INSERT INTO `departments` VALUES('22','IT','1');
INSERT INTO `departments` VALUES('23','Accounts and Admnistration','2');
INSERT INTO `departments` VALUES('24','Credit','2');
INSERT INTO `departments` VALUES('26','Marketing','2');
INSERT INTO `departments` VALUES('27','IT','2');
INSERT INTO `departments` VALUES('33','Corporate Services','0');
INSERT INTO `departments` VALUES('34','Monitoring and Evaluation','0');
INSERT INTO `departments` VALUES('39','IT','19');
INSERT INTO `departments` VALUES('40','FINANCE','19');
INSERT INTO `departments` VALUES('41','BUSINESS DEVELOPMENT','19');
INSERT INTO `departments` VALUES('42','CREDIT','19');
INSERT INTO `departments` VALUES('43','HUMAN RESOURCES','19');
INSERT INTO `departments` VALUES('44','IT Department','9');
INSERT INTO `departments` VALUES('45','Accounts Department','9');
INSERT INTO `departments` VALUES('46','EXECUTIVE MANAGEMENT','19');
INSERT INTO `departments` VALUES('47','Executive Management','18');
INSERT INTO `departments` VALUES('48','Finance','18');
INSERT INTO `departments` VALUES('49','Information Technology','18');
INSERT INTO `departments` VALUES('50','Operations','18');
INSERT INTO `departments` VALUES('51','INFORMATION TECHNOLOGY','17');
INSERT INTO `departments` VALUES('52','FINANCE AND ACCOUNTING','17');
INSERT INTO `departments` VALUES('53','MANAGEMENT','17');
INSERT INTO `departments` VALUES('54','MEMBER SERVICE AND MARKETING','17');
INSERT INTO `departments` VALUES('55','MANAGEMENT','20');
INSERT INTO `departments` VALUES('56','FINANCE AND ADMINISTRATION OFFICER','20');
INSERT INTO `departments` VALUES('57','IT DEPARTMENT','20');
INSERT INTO `departments` VALUES('58','OPERATIONS','20');
INSERT INTO `departments` VALUES('59','Business development','12');
INSERT INTO `departments` VALUES('60','Marketing Department','9');
INSERT INTO `departments` VALUES('61','Management','9');
DROP TABLE IF EXISTS `des`;

CREATE TABLE `des` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `de_id` varchar(60) NOT NULL,
  `first_name` varchar(64) NOT NULL,
  `last_name` varchar(32) NOT NULL,
  `email_address` varchar(32) DEFAULT NULL,
  `phone_number` varchar(32) DEFAULT NULL,
  `location` varchar(128) DEFAULT NULL,
  `graduation_date` date DEFAULT NULL,
  `sponsored_by` varchar(60) DEFAULT NULL,
  `date_registered` timestamp NOT NULL DEFAULT current_timestamp(),
  `profile_pic` varchar(64) DEFAULT NULL,
  `project` text DEFAULT NULL,
  `current_job` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `des` VALUES('1','CIEpGhsSbm9rgwakucQ8aIH3Ju7WhSbr0lkYBBfShg0jcQHob','Daniel','Imfa','dimfa@muscco.org','0999587051','Lilongwe','2017-11-19','1','2023-12-19 09:06:25','Daniel_1702994785.jpg','','');
DROP TABLE IF EXISTS `discussion_replies`;

CREATE TABLE `discussion_replies` (
  `reply_id` int(11) NOT NULL AUTO_INCREMENT,
  `topic_id` int(11) NOT NULL,
  `reply` text NOT NULL,
  `replied_by` varchar(60) NOT NULL,
  `date_replied` timestamp NOT NULL DEFAULT current_timestamp(),
  `member_of` int(11) NOT NULL,
  PRIMARY KEY (`reply_id`)
) ENGINE=InnoDB AUTO_INCREMENT=19 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `discussion_replies` VALUES('5','2','Timely development. This will make us save on phone calls while calling for statements','SlprCdlwOoVFnlS0','2024-01-12 08:51:02','10');
INSERT INTO `discussion_replies` VALUES('6','2','Thank you','xJjYpUTNT7JNk0mu2rySeBrQMH7dHKp6JtB80','2024-01-12 12:37:39','18');
INSERT INTO `discussion_replies` VALUES('7','3','Interesting subject','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','2024-01-22 04:04:33','0');
INSERT INTO `discussion_replies` VALUES('8','3','Sure what do we','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2024-01-22 04:05:25','0');
INSERT INTO `discussion_replies` VALUES('9','5','ok point of correction','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2026-02-04 17:08:44','0');
INSERT INTO `discussion_replies` VALUES('10','5','uj','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2026-02-04 17:11:21','0');
INSERT INTO `discussion_replies` VALUES('11','5','','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2026-02-04 17:11:23','0');
INSERT INTO `discussion_replies` VALUES('12','5','ok point of correction','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2026-02-04 17:11:34','0');
INSERT INTO `discussion_replies` VALUES('13','6','Waiting for ur comments guys','m2qYOyqKVKErImdlwCImuwgg','2026-02-06 14:09:23','0');
INSERT INTO `discussion_replies` VALUES('14','6','ok','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-06 14:18:12','0');
INSERT INTO `discussion_replies` VALUES('15','6','','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-06 14:18:13','0');
INSERT INTO `discussion_replies` VALUES('16','6','paid pat','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-06 14:18:22','0');
INSERT INTO `discussion_replies` VALUES('17','6','ok man','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-06 14:18:41','0');
INSERT INTO `discussion_replies` VALUES('18','6','ok thats Good those are my suggestions','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2026-02-07 01:11:21','0');
DROP TABLE IF EXISTS `discussions`;

CREATE TABLE `discussions` (
  `topic_id` int(11) NOT NULL AUTO_INCREMENT,
  `topic` text NOT NULL,
  `description` text NOT NULL,
  `access_rights` int(11) NOT NULL DEFAULT 0,
  `posted_by` varchar(60) NOT NULL,
  `date_posted` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`topic_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `discussions` VALUES('2','Welcome to Staff Portal','Team 

Welcome to staff portal developed with one objective, which is to stream line communication between affiliates and national association.
SACCOs will be able to receive and download statements and invoices for all training activities which Sacco staff attended.
Once again thank and enjoy.','1','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2024-01-12 08:49:23');
INSERT INTO `discussions` VALUES('3','Business Dev','What is business Dev. in relation to Anthony','0','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2024-01-22 04:03:23');
INSERT INTO `discussions` VALUES('4','SACCO Technical Support','This is the area where SACCO Technical Support will be discussed. Kindly share the support you have provided to SACCOs around you.','0','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2024-04-29 04:49:35');
INSERT INTO `discussions` VALUES('5','Portal Operationalisation Training','Portal Operationalisation Training','2','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2026-02-04 16:43:22');
INSERT INTO `discussions` VALUES('6','Muscco Expansion','Muscco Expansion','2','m2qYOyqKVKErImdlwCImuwgg','2026-02-06 14:09:02');
DROP TABLE IF EXISTS `document_categories`;

CREATE TABLE `document_categories` (
  `category_id` int(11) NOT NULL AUTO_INCREMENT,
  `category` varchar(1028) NOT NULL,
  PRIMARY KEY (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `document_categories` VALUES('1','Loan Application Forms');
INSERT INTO `document_categories` VALUES('2','Leave Application Forms');
INSERT INTO `document_categories` VALUES('8','New Form');
INSERT INTO `document_categories` VALUES('9','Newsletters');
INSERT INTO `document_categories` VALUES('10','Statistics');
INSERT INTO `document_categories` VALUES('11','SACCO Bylaws');
INSERT INTO `document_categories` VALUES('12','Vehicle Requests');
INSERT INTO `document_categories` VALUES('13','General');
INSERT INTO `document_categories` VALUES('14','Books and Publications');
INSERT INTO `document_categories` VALUES('15','Presentations');
INSERT INTO `document_categories` VALUES('16','CEO Desk');
INSERT INTO `document_categories` VALUES('17','MUSCCO Policies');
INSERT INTO `document_categories` VALUES('18','Asset Disposal 2024');
INSERT INTO `document_categories` VALUES('19','new ob');
INSERT INTO `document_categories` VALUES('20','new ob');
DROP TABLE IF EXISTS `documents`;

CREATE TABLE `documents` (
  `document_id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(1028) NOT NULL,
  `description` text DEFAULT NULL,
  `document_file` varchar(128) NOT NULL,
  `category_id` int(11) NOT NULL,
  `access_rights` int(11) NOT NULL DEFAULT 0,
  `document_status` int(11) NOT NULL DEFAULT 0,
  `date_posted` timestamp NOT NULL DEFAULT current_timestamp(),
  `posted_by` varchar(60) NOT NULL,
  PRIMARY KEY (`document_id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `documents` VALUES('1','Human Resource Management Best Practices','','1449991422_1701956591.pdf','14','1','0','2023-12-07 08:43:11','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('2','Cooperative Risk Management Tool','','1579522839_1701956685.pdf','14','1','0','2023-12-07 08:44:45','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('3','PEARLS Teachnical Guide','','2023745700_1701956779.pdf','14','1','0','2023-12-07 08:46:19','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('4','Governance in SACCOs','','630739374_1701956836.pdf','14','2','0','2023-12-07 08:47:16','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('5','SACCOs and SDGs - SACCOs as Enabler of 7 out 17 SDGs','','435831533_1701956917.pdf','15','2','0','2023-12-07 08:48:37','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('6','Supervisory Committee Manual','','370035369_1701956996.pdf','14','1','0','2023-12-07 08:49:56','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('7','Confidence is Capital - How to Build your Confidence','','1012466598_1701957076.pdf','15','0','0','2023-12-07 08:51:16','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('8','SACCO Performance Management','','1534255253_1701957129.pdf','15','2','0','2023-12-07 08:52:09','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('9','The 7 SACCO Deadly Sins','','1516851938_1701957179.pdf','15','1','0','2023-12-07 08:52:59','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('10','SACCO Impact for Chapter','','1701960868_1701957237.pdf','15','1','0','2023-12-07 08:53:57','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('11','SACCO board Management Relationship - A Look at the Global Perspective','','307888305_1701957271.pdf','15','1','0','2023-12-07 08:54:31','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('12','Business Success - The role of Leadership','','1575877801_1701957360.pdf','15','1','0','2023-12-07 08:56:00','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('13','How to take care of MUSCCO Computers','','999192194_1701957490.pdf','14','0','0','2023-12-07 08:58:10','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('14','The importance of Cooperative Principles in The financial Cooperative Model','','1595814118_1701957839.pdf','15','2','0','2023-12-07 09:03:59','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('15','MEMO 1','','443043015_1704704669.pdf','16','0','0','2024-01-08 04:04:29','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('16','Beneficiary Nomination Form','','50281024_1704978170.pdf','8','0','0','2024-01-11 08:02:50','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('17','Travel Allowances Adjustment','','1188674494_1705050025.pdf','13','0','0','2024-01-12 04:00:25','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('18','MUSCCO HR and Admin Policy','','141649512_1705398759.pdf','13','0','0','2024-01-16 04:52:39','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('19','MUSCCO HR and Admin Policy','','1249523164_1719217934.pdf','17','0','0','2024-06-24 04:32:14','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('20','Information Technology  Policy','','1280021196_1719218439.docx','17','0','0','2024-06-24 04:40:39','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('21','MUSCCO Bylaws','','655808005_1719218502.doc','17','0','0','2024-06-24 04:41:42','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('22','MUSCCO Communication Policy','','426268233_1719218542.docx','17','0','0','2024-06-24 04:42:22','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('23','MUSCCO Anti Fraud &amp; Anti Corruption Policy','','1828729753_1719218580.docx','17','0','0','2024-06-24 04:43:00','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('24','MUSCCO HIV and AIDS Policy','','1993427712_1719218619.docx','17','0','0','2024-06-24 04:43:39','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('25','MUSCCO Gender Policy','','1722339119_1719218648.docx','17','0','0','2024-06-24 04:44:08','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('26','MUSCCO Fuel Policy','','247748424_1719218672.pdf','17','0','0','2024-06-24 04:44:32','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('27','IT Business Continuity Plan','','431322372_1719218755.docx','17','0','0','2024-06-24 04:45:55','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('28','Paid External Consulting Policy','','609415983_1719218829.docx','17','0','0','2024-06-24 04:47:09','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('29','MUSCCO Environmental and Social Management  Policy','','1128591115_1719218879.docx','17','0','0','2024-06-24 04:47:59','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('30','MUSCCO Procurement Policy','','1157854912_1719218984.doc','17','0','0','2024-06-24 04:49:44','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('31','MUSCCO Conflict of Interest Policy','','385890866_1719219030.doc','17','0','0','2024-06-24 04:50:30','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('32','MUSCCO Backup Policy','','1995012094_1719219075.doc','17','0','0','2024-06-24 04:51:15','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('33','MUSCCO Information Technology  Password Policy','','771158963_1719219879.doc','17','0','0','2024-06-24 05:04:39','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('34','Asset Sale Bid Form','','107161568_1726849393.pdf','18','0','0','2024-09-20 12:23:13','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('36','Obselete Assets Sale Instruction Memo','','228562104_1726849696.pdf','18','0','0','2024-09-20 12:28:16','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('37','Asset Disposal List','','1946546710_1726857828.pdf','18','0','0','2024-09-20 14:43:48','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('38','NEW 26 FORM','','98272517_1770241245.pdf','8','1','0','2026-02-04 16:40:45','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `documents` VALUES('39','Pre OB','','1441387141_1770405195.docx','15','2','0','2026-02-06 14:13:15','m2qYOyqKVKErImdlwCImuwgg');
INSERT INTO `documents` VALUES('40','Stati document','','1462554863_1770444813.docx','10','2','0','2026-02-07 01:13:33','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `event_id` int(11) NOT NULL AUTO_INCREMENT,
  `event_title` varchar(1028) NOT NULL,
  `event_description` text NOT NULL,
  `venue` varchar(1028) NOT NULL,
  `date_from` date NOT NULL,
  `date_to` date NOT NULL,
  `time_from` time NOT NULL,
  `time_to` time NOT NULL,
  `event_attachment` varchar(32) DEFAULT NULL,
  `posted_by` varchar(60) NOT NULL,
  `date_posted` timestamp NOT NULL DEFAULT current_timestamp(),
  `event_status` int(11) NOT NULL DEFAULT 0,
  `event_permision` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`event_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `events` VALUES('1','ENMMERGENCY MEETING','OK','BOARD ROOM','2026-02-28','2026-02-28','01:37:00','02:38:00','','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2026-02-04 16:39:40','2','0');
INSERT INTO `events` VALUES('2','POLYMED SACCO NAGM','new AGM','KUHES','2026-02-21','2026-02-28','14:00:00','16:18:00','1256968347_muscco_event.jpg','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2026-02-07 01:21:09','2','2');
INSERT INTO `events` VALUES('3','AGM','OK','SALIMA','2026-02-07','2026-02-07','13:34:00','16:34:00','','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2026-02-07 01:36:22','1','2');
DROP TABLE IF EXISTS `faqs`;

CREATE TABLE `faqs` (
  `faq_id` int(11) NOT NULL AUTO_INCREMENT,
  `question` text NOT NULL,
  `answer` text NOT NULL,
  `date_posted` timestamp NOT NULL DEFAULT current_timestamp(),
  `posted_by` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`faq_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `faqs` VALUES('1','What are the benefits of Keeping money in the SACCO?','Members have a voice in the running of the SACCO since they own the institution; Members receive dividends at the end of the financial year; Access to financial services is non-discriminatory and affordable Contribution to a positive community','2024-01-12 02:18:16','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `faqs` VALUES('2','Does MUSCCO have social media platforms?','Yes - MUSCCO is on facebook and Twitter','2024-01-12 02:27:15','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `faqs` VALUES('4','List of Saccos in Malawi','Polymed Sacco, MUdi Sacco etc','2026-02-07 01:07:06','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
DROP TABLE IF EXISTS `fuel_prices`;

CREATE TABLE `fuel_prices` (
  `fuel_id` int(11) NOT NULL AUTO_INCREMENT,
  `fuel` varchar(32) NOT NULL,
  `current_price` double NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`fuel_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `fuel_prices` VALUES('1','Diesel','4996','2023-08-17 10:40:03');
INSERT INTO `fuel_prices` VALUES('2','Petrol','4994','2023-08-17 10:40:03');
DROP TABLE IF EXISTS `invoice_status`;

CREATE TABLE `invoice_status` (
  `change_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_id` int(11) NOT NULL,
  `comment` text NOT NULL,
  `paid_amount` double NOT NULL DEFAULT 0,
  `attachment` varchar(128) DEFAULT NULL,
  `updated_by` varchar(60) NOT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`change_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `invoice_status` VALUES('1','1','balance','10000','','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-04 18:29:26');
INSERT INTO `invoice_status` VALUES('2','2','paid pat','20000','attachment_124.pdf','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-04 18:33:28');
DROP TABLE IF EXISTS `invoices`;

CREATE TABLE `invoices` (
  `invoice_id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice_number` varchar(32) NOT NULL,
  `sacco_id` int(11) NOT NULL,
  `description` varchar(1028) NOT NULL,
  `amount` double NOT NULL,
  `amount_paid` double NOT NULL DEFAULT 0,
  `balance` double NOT NULL DEFAULT 0,
  `invoice_file` varchar(128) NOT NULL,
  `invoice_status` int(11) NOT NULL DEFAULT 0,
  `posted_by` varchar(60) NOT NULL,
  `date_posted` date NOT NULL,
  `due_date` date DEFAULT NULL,
  PRIMARY KEY (`invoice_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `invoices` VALUES('1','1','11','Students','20000','20000','0','muscco_invoice_1.jpg','1','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-04','2026-02-25');
INSERT INTO `invoices` VALUES('2','124','14','Individuals not employed','100000','0','0','muscco_invoice_124.pdf','1','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-04','2026-02-12');
INSERT INTO `invoices` VALUES('3','345','14','Students','20000','8','0','muscco_invoice_345.docx','0','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-06','2026-02-13');
DROP TABLE IF EXISTS `leave_applications`;

CREATE TABLE `leave_applications` (
  `application_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` varchar(60) NOT NULL,
  `leave_type` int(11) NOT NULL,
  `date_start` date NOT NULL,
  `date_end` date NOT NULL,
  `leave_days` double NOT NULL DEFAULT 0,
  `reason` text DEFAULT NULL,
  `leave_roaster` text NOT NULL,
  `leave_grant` text NOT NULL,
  `checked_by` varchar(60) DEFAULT NULL,
  `verified_by` varchar(60) DEFAULT NULL,
  `approved_by` varchar(60) DEFAULT NULL,
  `declined_by` varchar(60) DEFAULT NULL,
  `fy_id` int(11) NOT NULL,
  `leave_status` int(11) NOT NULL DEFAULT 0,
  `date_requested` timestamp NOT NULL DEFAULT current_timestamp(),
  `date_checked` date DEFAULT NULL,
  `date_verified` date DEFAULT NULL,
  `date_approved` date DEFAULT NULL,
  `date_declined` date DEFAULT NULL,
  `approval_note` text DEFAULT NULL,
  `check_reasons` text DEFAULT NULL,
  `verify_reasons` text DEFAULT NULL,
  `approve_reasons` text DEFAULT NULL,
  `decline_reason` text DEFAULT NULL,
  PRIMARY KEY (`application_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `leave_applications` VALUES('1','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','2024-01-09','2024-01-13','4','Travelling to Njululubwa','Yes','No','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','','3','3','2024-01-08 04:51:53','2026-02-05','2026-02-05','2026-02-05','','','ok','ok','ok','');
INSERT INTO `leave_applications` VALUES('2','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','6','2026-02-05','2026-02-06','2','ok','Yes','Yes','','','','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','4','4','2026-02-04 19:21:18','','','','2026-02-06','','','','','All is good, he can go');
INSERT INTO `leave_applications` VALUES('3','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','1','2026-02-10','2026-02-13','4','I want to go home and rest.','No','No','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','','4','3','2026-02-06 09:47:15','2026-02-06','2026-02-06','2026-02-06','','','He can go','All is good, he can go','Its approved.','');
INSERT INTO `leave_applications` VALUES('4','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','1','2026-02-10','2026-03-06','18','Ndikapume','No','No','','','','','7','0','2026-02-06 10:53:00','','','','','','','','','');
INSERT INTO `leave_applications` VALUES('5','m2qYOyqKVKErImdlwCImuwgg','1','2026-02-06','2026-02-28','16','ok','Yes','No','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','','7','3','2026-02-06 14:21:20','2026-02-06','2026-02-06','2026-02-06','','','ok','ok','ok','');
DROP TABLE IF EXISTS `leave_days`;

CREATE TABLE `leave_days` (
  `record_id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(60) NOT NULL,
  `leave_id` int(11) NOT NULL,
  `fy_id` int(11) NOT NULL,
  `days_entitled` double NOT NULL,
  `days_taken` double NOT NULL,
  `days_remaining` double NOT NULL,
  `date_updated` timestamp NOT NULL DEFAULT current_timestamp(),
  `updated_by` varchar(60) NOT NULL,
  PRIMARY KEY (`record_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `leave_days` VALUES('1','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','3','24','4','20','2024-01-08 04:49:32','YS3870fdsPY1LhX304');
INSERT INTO `leave_days` VALUES('2','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','3','3','7','0','7','2024-01-08 04:49:58','YS3870fdsPY1LhX304');
INSERT INTO `leave_days` VALUES('3','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2','3','90','0','90','2024-01-08 04:50:08','YS3870fdsPY1LhX304');
INSERT INTO `leave_days` VALUES('4','vRrjIqmw9m5lM4sorbq7R2','1','4','23','0','23','2026-02-04 19:19:12','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl');
INSERT INTO `leave_days` VALUES('5','vRrjIqmw9m5lM4sorbq7R2','2','4','33','0','33','2026-02-04 19:19:26','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl');
INSERT INTO `leave_days` VALUES('6','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','6','4','2','0','2','2026-02-04 19:20:37','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl');
INSERT INTO `leave_days` VALUES('7','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','1','4','26','4','22','2026-02-06 09:46:46','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6');
INSERT INTO `leave_days` VALUES('8','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','1','7','30','18','12','2026-02-06 10:52:53','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6');
INSERT INTO `leave_days` VALUES('9','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','1','7','26','0','26','2026-02-06 11:03:16','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6');
INSERT INTO `leave_days` VALUES('10','m2qYOyqKVKErImdlwCImuwgg','1','7','22','16','6','2026-02-06 14:17:53','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl');
DROP TABLE IF EXISTS `leave_entitlement`;

CREATE TABLE `leave_entitlement` (
  `entitled_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` varchar(60) NOT NULL,
  `type_id` int(11) NOT NULL,
  `entitlement` double NOT NULL DEFAULT 0,
  `days_taken` double NOT NULL DEFAULT 0,
  `days_remaining` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`entitled_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `leave_entitlement` VALUES('1','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','24','0','0');
INSERT INTO `leave_entitlement` VALUES('2','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','3','7','0','0');
INSERT INTO `leave_entitlement` VALUES('3','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2','90','0','0');
INSERT INTO `leave_entitlement` VALUES('4','vRrjIqmw9m5lM4sorbq7R2','1','23','0','0');
INSERT INTO `leave_entitlement` VALUES('5','vRrjIqmw9m5lM4sorbq7R2','2','33','0','0');
INSERT INTO `leave_entitlement` VALUES('6','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','6','2','0','0');
INSERT INTO `leave_entitlement` VALUES('7','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','1','30','0','0');
INSERT INTO `leave_entitlement` VALUES('8','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','1','30','0','0');
INSERT INTO `leave_entitlement` VALUES('9','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','1','26','0','0');
INSERT INTO `leave_entitlement` VALUES('10','m2qYOyqKVKErImdlwCImuwgg','1','22','0','0');
DROP TABLE IF EXISTS `leave_fy`;

CREATE TABLE `leave_fy` (
  `fy_id` int(11) NOT NULL AUTO_INCREMENT,
  `fy` year(4) NOT NULL,
  `fy_status` int(11) NOT NULL DEFAULT 0,
  `updated_by` varchar(60) NOT NULL,
  PRIMARY KEY (`fy_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `leave_fy` VALUES('3','2023','1','');
INSERT INTO `leave_fy` VALUES('4','2024','1','YS3870fdsPY1LhX304');
INSERT INTO `leave_fy` VALUES('7','2026','0','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6');
DROP TABLE IF EXISTS `leave_types`;

CREATE TABLE `leave_types` (
  `type_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(1028) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `leave_types` VALUES('1','Annual Leave','Paid leave');
INSERT INTO `leave_types` VALUES('2','Sick Leave','A leave based on medical grounds');
INSERT INTO `leave_types` VALUES('3','Study Leave','A leave for those studying');
INSERT INTO `leave_types` VALUES('4','Maternity','Given to female Employees after giving Biirth');
INSERT INTO `leave_types` VALUES('9','Compassionate Leave','Compassionate');
DROP TABLE IF EXISTS `loans`;

CREATE TABLE `loans` (
  `loan_id` int(11) NOT NULL AUTO_INCREMENT,
  `sacco_id` varchar(60) NOT NULL,
  `amount` double NOT NULL,
  `purpose` varchar(1028) NOT NULL,
  `application_form` varchar(60) NOT NULL,
  `posted_by` varchar(60) NOT NULL,
  `date_posted` timestamp NOT NULL DEFAULT current_timestamp(),
  `loan_status` int(11) NOT NULL DEFAULT 0,
  `loan_interest` double DEFAULT NULL,
  `total_loan` double DEFAULT NULL,
  `amount_paid` double NOT NULL DEFAULT 0,
  `loan_balance` double NOT NULL DEFAULT 0,
  `muscco_form` varchar(60) DEFAULT NULL,
  `loan_remarks` text DEFAULT NULL,
  `date_updated` date DEFAULT NULL,
  `updated_by` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`loan_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
DROP TABLE IF EXISTS `members`;

CREATE TABLE `members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` varchar(60) NOT NULL,
  `first_name` varchar(32) NOT NULL,
  `last_name` varchar(32) NOT NULL,
  `email_address` varchar(32) NOT NULL,
  `password` varchar(60) NOT NULL,
  `phone_number` varchar(32) NOT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `user_role` int(11) NOT NULL DEFAULT 0,
  `login_trials` int(11) NOT NULL DEFAULT 0,
  `member_of` int(11) NOT NULL DEFAULT 0,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
DROP TABLE IF EXISTS `muscco_members`;

CREATE TABLE `muscco_members` (
  `muscco_id` int(11) NOT NULL AUTO_INCREMENT,
  `muscco_member_id` varchar(60) NOT NULL,
  `employee_id` varchar(32) DEFAULT NULL,
  `band_id` int(11) NOT NULL,
  `first_name` varchar(32) NOT NULL,
  `last_name` varchar(32) NOT NULL,
  `email_address` varchar(128) NOT NULL,
  `phone_number` varchar(32) NOT NULL,
  `position_id` int(11) NOT NULL,
  `department_id` int(11) NOT NULL,
  `dob` date NOT NULL,
  `join_date` date DEFAULT NULL,
  `thumb` varchar(62) DEFAULT NULL,
  `branch` varchar(32) DEFAULT NULL,
  `profile` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`muscco_id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `muscco_members` VALUES('1','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','MUSCCO/01/104q','2','Wezzie','Mhango','wezmhango@hotmail.com','0993189240','1','1','1988-01-01','2011-01-01','Jamess_1699858340.jpg','2','A recent business economics graduate with a 2:1 honours degree from the University of X, looking to secure a Graduate Commercial Analyst position to use and further develop my analytical skills and knowledge in a practical and fast-paced environment. My career goal is to assume a role which allows me to take responsibility for the analysis and interpretation of commercial data for a well-respected and market-leading leading company.');
INSERT INTO `muscco_members` VALUES('35','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','MUS 005','2','Daniel','Imfa','dimfa@muscco.org','0999587051','43','1','1978-04-19','2010-04-01','Daniel_1702968918.jpg','2','Seasoned IT profession with passion for Credit Union. Cert Digi Money, MA,  Bsc.');
INSERT INTO `muscco_members` VALUES('36','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','MUS 007','3','Andole','Mang&apos;anya','amanganya@muscco.org','0881367852','46','33','1984-09-14','2019-10-14','Andole_1701095112.jpg','2','');
INSERT INTO `muscco_members` VALUES('37','havCLHBjolrH5wI6cnP3UyAqHKvS3kC6thavU4pD8vW0qh0vuJCTYGDU','MUS 007','3','Bless','Zikomakuka','bkzikomakuka@muscco.org','0884042225','36','11','1993-10-09','2019-09-29','Bless_1702967620.jpg','2','');
INSERT INTO `muscco_members` VALUES('38','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','MUS 004','1','Leroy','Banda','leroybanda@muscco.org','0888863135','45','11','1967-11-26','2000-03-03','Leroy_1702968776.jpg','2','');
INSERT INTO `muscco_members` VALUES('39','cN7XJK4EJgIcFZ3P4pL','MUS 098','3','Emmanuel','Kaziona','ekaziona@muscco.org','0993 818 030','39','4','1990-03-07','2020-06-01','Emmanuel_1702967568.jpg','2','');
INSERT INTO `muscco_members` VALUES('40','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','MUS 087','3','Anthony','Makuluni','amakuluni@muscco.org','0888878879','42','11','1971-11-07','2018-10-01','Anthony_1702967859.jpg','4','');
INSERT INTO `muscco_members` VALUES('41','vRrjIqmw9m5lM4sorbq7R2','MUS 084','4','Tawama','Yambani','tyambani@muscco.org','0881155837','38','4','1993-04-29','2018-08-01','Tawama_1702968097.jpg','4','');
INSERT INTO `muscco_members` VALUES('42','2nK9f2qboFJYiMJcJoTWQXccS6TcrtKtX8I','MUS 069','2','Marko','Nkhoma','mnkhoma@muscco.org','0999587076','41','20','1976-09-01','2016-12-05','Marko_1702988623.jpg','2','');
INSERT INTO `muscco_members` VALUES('43','lTYqrrnO3Qpi4Q','MUS 017','4','Patrick','Lunda','plunda@muscco.org','0993964808','38','4','1974-05-09','2004-09-30','Patrick_1702968434.jpg','2','');
INSERT INTO `muscco_members` VALUES('44','FtFFeM1Yb17UWcqIqodm4csT','MUS 003','2','Rose','Chalendewa','rchalendewa@muscco.org','0999139859','35','4','1981-07-16','2022-08-01','Rose_1702968739.jpg','2','');
INSERT INTO `muscco_members` VALUES('45','inAJsQeZy13r6c5xRI8i0','MUS 011','1','Kingsley','Mulewa','kmulewa@muscco.org','0888317154','40','4','1973-01-08','2023-10-02','Kingsley _1702970485.jpg','2','');
INSERT INTO `muscco_members` VALUES('46','RWM9poiBTms','MUS 002','1','Fumbani','Nyangulu','fnyangulu@muscco.org','0888875928','17','33','1973-07-01','1997-04-01','Fumbani _1702970805.jpg','2','');
INSERT INTO `muscco_members` VALUES('47','IIXiuVLQbocEsCBidtKrqGQl6WtTm','MUS 080','4','Benson','Naphazi','bnaphazi@muscco.org','0999309554','3','3','1982-08-02','2017-11-11','','2','');
INSERT INTO `muscco_members` VALUES('48','QWiEBixN9WstbEGkqEvp','MUS 009','2','Ezeckiel','Thindwa','ethindwa@muscco.org','0888327804','34','11','1971-05-08','1999-03-15','Ezeckiel_1702989520.jpg','2','');
INSERT INTO `muscco_members` VALUES('49','aOTFPSYcTJxGpjfq5xhLRJMZwZa','MUS 091','3','Pharaoh','Chikhula','pchikhula@muscco.org','0881 304 301','33','20','1990-09-05','2019-04-24','Pharaoh_1702993489.jpg','4','');
INSERT INTO `muscco_members` VALUES('50','dYN9VwdDjjomFjekCG1C8ZtKcDSO3jLYjWYGGy','MUS 072','4','Salome','Hara','shara@muscco.org','0884460758','37','3','1990-11-14','2017-03-06','Salome_1702994525.jpg','3','');
INSERT INTO `muscco_members` VALUES('51','ZC2UrkGa5cobAdVmgWVPXEDb0th6FlcgV','MUS 088','4','Chisomo','Duwe','cduwe@muscco.org','0882509199','37','3','1996-09-13','2018-09-24','Chisomo_1704706662.jpg','2','');
INSERT INTO `muscco_members` VALUES('52','YS3870fdsPY1LhX304','MUS 052','3','Osley','Chikhasu','ochikhasu@muscco.org','0999158224','44','11','1967-09-21','2014-01-01','Osley_1704704432.jpg','2','');
INSERT INTO `muscco_members` VALUES('54','3kfqGBPLsb7vRjg05zQSANue9V1','202401','3','Owen','Banda','ob@gmail.com','','44','1','2011-01-01','2024-05-01','','4','');
INSERT INTO `muscco_members` VALUES('55','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','001','1','Test','User','testuser@muscco.org','','39','20','1991-10-10','2009-10-10','','4','');
INSERT INTO `muscco_members` VALUES('56','m2qYOyqKVKErImdlwCImuwgg','34','5','Martha','Banda','obanda@mca.ac.mw','0882297414','43','20','1961-01-12','2026-02-05','Martha_1770404132.jpg','4','');
INSERT INTO `muscco_members` VALUES('57','IDauGul','123D4','1','Gerald','Buleya','obanda@mca.ac.mw','0882297414','46','33','2007-02-06','2026-02-05','Gerald_1770404227.jpg','2','');
INSERT INTO `muscco_members` VALUES('58','rsxQhzblS7LK6ErYLILFVUUxNbULOwlapGTu70Qn6kaJn8UqtgbUtXOQYX','3456','7','Mwayi','Chatsika','obanda@mca.ac.mw','0882297414','36','1','2000-05-14','2012-03-09','Mwayi_1770447603.jpg','4','');
DROP TABLE IF EXISTS `notifications`;

CREATE TABLE `notifications` (
  `notification_id` int(11) NOT NULL AUTO_INCREMENT,
  `posted_by` varchar(60) NOT NULL,
  `received_by` varchar(60) NOT NULL,
  `subject` text NOT NULL,
  `message` text NOT NULL,
  `status` int(11) NOT NULL DEFAULT 0,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`notification_id`)
) ENGINE=InnoDB AUTO_INCREMENT=263 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `notifications` VALUES('1','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new leave application(#1) to check','Hey Andole, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2024-01-08 04:51:53');
INSERT INTO `notifications` VALUES('2','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new leave application(#1) to check','Hey Anthony, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2024-01-08 04:51:53');
INSERT INTO `notifications` VALUES('3','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new leave application(#1) to check','Hey Fumbani, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2024-01-08 04:51:54');
INSERT INTO `notifications` VALUES('4','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new leave application(#1) to check','Hey Kingsley, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2024-01-08 04:51:54');
INSERT INTO `notifications` VALUES('6','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','YS3870fdsPY1LhX304','You have received a new leave application(#1) to check','Hey Osley, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2024-01-08 04:51:54');
INSERT INTO `notifications` VALUES('8','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0002)','Hey Anthony, you have received a new petty cash requisition(#0002) that needs your attention','0','2024-01-08 08:04:02');
INSERT INTO `notifications` VALUES('9','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new petty cash requisition(#0002)','Hey Fumbani, you have received a new petty cash requisition(#0002) that needs your attention','0','2024-01-08 08:04:02');
INSERT INTO `notifications` VALUES('10','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0002)','Hey Kingsley, you have received a new petty cash requisition(#0002) that needs your attention','0','2024-01-08 08:04:02');
INSERT INTO `notifications` VALUES('12','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0003)','Hey Anthony, you have received a new petty cash requisition(#0003) that needs your attention','0','2024-01-13 09:51:12');
INSERT INTO `notifications` VALUES('13','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new petty cash requisition(#0003)','Hey Fumbani, you have received a new petty cash requisition(#0003) that needs your attention','0','2024-01-13 09:51:12');
INSERT INTO `notifications` VALUES('14','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0003)','Hey Kingsley, you have received a new petty cash requisition(#0003) that needs your attention','0','2024-01-13 09:51:12');
INSERT INTO `notifications` VALUES('15','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0003)','Hey Rose, you have received a new petty cash requisition(#0003) that needs your attention','0','2024-01-13 09:51:12');
INSERT INTO `notifications` VALUES('16','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','MUS 005','Your travel advance request has been Approved','Hey, your travel advance request that you posted has been Approved, go to details to check the update','0','2024-01-24 02:05:00');
INSERT INTO `notifications` VALUES('17','inAJsQeZy13r6c5xRI8i0','MUS 005','Your travel advance request has been Declined','Hey, your travel advance request that you posted has been Declined, go to details to check the update','0','2024-01-24 03:38:49');
INSERT INTO `notifications` VALUES('18','inAJsQeZy13r6c5xRI8i0','MUS 052','Your travel advance request has been Declined','Hey, your travel advance request that you posted has been Declined, go to details to check the update','0','2024-01-24 03:39:12');
INSERT INTO `notifications` VALUES('19','inAJsQeZy13r6c5xRI8i0','MUS 005','Your travel advance request has been Declined','Hey, your travel advance request that you posted has been Declined, go to details to check the update','0','2024-01-24 03:39:33');
INSERT INTO `notifications` VALUES('20','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0002)','Hey Rose, you have received a new staff advance request(#0002) that needs your attention.','0','2024-01-25 06:56:16');
INSERT INTO `notifications` VALUES('21','havCLHBjolrH5wI6cnP3UyAqHKvS3kC6thavU4pD8vW0qh0vuJCTYGDU','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0003)','Hey Rose, you have received a new staff advance request(#0003) that needs your attention.','0','2024-01-26 07:30:59');
INSERT INTO `notifications` VALUES('22','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0004)','Hey Anthony, you have received a new petty cash requisition(#0004) that needs your attention, please log into the staff portal to check.','0','2024-09-20 13:05:08');
INSERT INTO `notifications` VALUES('23','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new petty cash requisition(#0004)','Hey Fumbani, you have received a new petty cash requisition(#0004) that needs your attention, please log into the staff portal to check.','0','2024-09-20 13:05:08');
INSERT INTO `notifications` VALUES('24','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0004)','Hey Kingsley, you have received a new petty cash requisition(#0004) that needs your attention, please log into the staff portal to check.','0','2024-09-20 13:05:09');
INSERT INTO `notifications` VALUES('25','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0004)','Hey Rose, you have received a new petty cash requisition(#0004) that needs your attention, please log into the staff portal to check.','0','2024-09-20 13:05:09');
INSERT INTO `notifications` VALUES('26','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0004)','Hey Emmanuel, you have received a new petty cash requisition(#0004) that needs your attention, please log into the staff portal to check.','0','2024-09-20 13:05:09');
INSERT INTO `notifications` VALUES('27','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0005)','Hey Anthony, you have received a new petty cash requisition(#0005) that needs your attention, please log into the staff portal to check.','0','2024-11-07 02:20:41');
INSERT INTO `notifications` VALUES('28','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new petty cash requisition(#0005)','Hey Fumbani, you have received a new petty cash requisition(#0005) that needs your attention, please log into the staff portal to check.','0','2024-11-07 02:20:41');
INSERT INTO `notifications` VALUES('29','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0005)','Hey Kingsley, you have received a new petty cash requisition(#0005) that needs your attention, please log into the staff portal to check.','0','2024-11-07 02:20:41');
INSERT INTO `notifications` VALUES('30','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0005)','Hey Rose, you have received a new petty cash requisition(#0005) that needs your attention, please log into the staff portal to check.','0','2024-11-07 02:20:41');
INSERT INTO `notifications` VALUES('31','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0005)','Hey Emmanuel, you have received a new petty cash requisition(#0005) that needs your attention, please log into the staff portal to check.','0','2024-11-07 02:20:41');
INSERT INTO `notifications` VALUES('32','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0006)','Hey Anthony, you have received a new petty cash requisition(#0006) that needs your attention, please log into the staff portal to check.','0','2024-11-07 04:57:05');
INSERT INTO `notifications` VALUES('33','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','RWM9poiBTms','You have received a new petty cash requisition(#0006)','Hey Fumbani, you have received a new petty cash requisition(#0006) that needs your attention, please log into the staff portal to check.','0','2024-11-07 04:57:05');
INSERT INTO `notifications` VALUES('34','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0006)','Hey Kingsley, you have received a new petty cash requisition(#0006) that needs your attention, please log into the staff portal to check.','0','2024-11-07 04:57:05');
INSERT INTO `notifications` VALUES('35','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0006)','Hey Rose, you have received a new petty cash requisition(#0006) that needs your attention, please log into the staff portal to check.','0','2024-11-07 04:57:05');
INSERT INTO `notifications` VALUES('36','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0006)','Hey Emmanuel, you have received a new petty cash requisition(#0006) that needs your attention, please log into the staff portal to check.','0','2024-11-07 04:57:05');
INSERT INTO `notifications` VALUES('37','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0007)','Hey Anthony, you have received a new petty cash requisition(#0007) that needs your attention, please log into the staff portal to check.','0','2024-11-07 05:10:09');
INSERT INTO `notifications` VALUES('38','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','RWM9poiBTms','You have received a new petty cash requisition(#0007)','Hey Fumbani, you have received a new petty cash requisition(#0007) that needs your attention, please log into the staff portal to check.','0','2024-11-07 05:10:11');
INSERT INTO `notifications` VALUES('39','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0007)','Hey Kingsley, you have received a new petty cash requisition(#0007) that needs your attention, please log into the staff portal to check.','0','2024-11-07 05:10:17');
INSERT INTO `notifications` VALUES('40','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0007)','Hey Rose, you have received a new petty cash requisition(#0007) that needs your attention, please log into the staff portal to check.','0','2024-11-07 05:10:23');
INSERT INTO `notifications` VALUES('41','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0007)','Hey Emmanuel, you have received a new petty cash requisition(#0007) that needs your attention, please log into the staff portal to check.','0','2024-11-07 05:10:29');
INSERT INTO `notifications` VALUES('42','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0008)','Hey Anthony, you have received a new petty cash requisition(#0008) that needs your attention, please log into the staff portal to check.','0','2024-11-07 05:11:52');
INSERT INTO `notifications` VALUES('43','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','RWM9poiBTms','You have received a new petty cash requisition(#0008)','Hey Fumbani, you have received a new petty cash requisition(#0008) that needs your attention, please log into the staff portal to check.','0','2024-11-07 05:11:52');
INSERT INTO `notifications` VALUES('44','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0008)','Hey Kingsley, you have received a new petty cash requisition(#0008) that needs your attention, please log into the staff portal to check.','0','2024-11-07 05:11:52');
INSERT INTO `notifications` VALUES('45','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0008)','Hey Rose, you have received a new petty cash requisition(#0008) that needs your attention, please log into the staff portal to check.','0','2024-11-07 05:11:52');
INSERT INTO `notifications` VALUES('46','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0008)','Hey Emmanuel, you have received a new petty cash requisition(#0008) that needs your attention, please log into the staff portal to check.','0','2024-11-07 05:11:52');
INSERT INTO `notifications` VALUES('47','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0009)','Hey Anthony, you have received a new petty cash requisition(#0009) that needs your attention, please log into the staff portal to check.','0','2024-11-11 03:27:48');
INSERT INTO `notifications` VALUES('48','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','RWM9poiBTms','You have received a new petty cash requisition(#0009)','Hey Fumbani, you have received a new petty cash requisition(#0009) that needs your attention, please log into the staff portal to check.','0','2024-11-11 03:27:51');
INSERT INTO `notifications` VALUES('49','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0009)','Hey Kingsley, you have received a new petty cash requisition(#0009) that needs your attention, please log into the staff portal to check.','0','2024-11-11 03:27:57');
INSERT INTO `notifications` VALUES('50','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0009)','Hey Rose, you have received a new petty cash requisition(#0009) that needs your attention, please log into the staff portal to check.','0','2024-11-11 03:28:03');
INSERT INTO `notifications` VALUES('51','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0009)','Hey Emmanuel, you have received a new petty cash requisition(#0009) that needs your attention, please log into the staff portal to check.','0','2024-11-11 03:28:09');
INSERT INTO `notifications` VALUES('52','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0004)','Hey Rose, you have received a new staff advance request(#0004) that needs your verification.','0','2026-02-04 17:21:10');
INSERT INTO `notifications` VALUES('53','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0005)','Hey Rose, you have received a new staff advance request(#0005) that needs your verification.','0','2026-02-04 17:23:48');
INSERT INTO `notifications` VALUES('54','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0006)','Hey Rose, you have received a new staff advance request(#0006) that needs your verification.','0','2026-02-04 17:25:27');
INSERT INTO `notifications` VALUES('55','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0007)','Hey Rose, you have received a new staff advance request(#0007) that needs your verification.','0','2026-02-04 17:25:48');
INSERT INTO `notifications` VALUES('56','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0008)','Hey Rose, you have received a new staff advance request(#0008) that needs your verification.','0','2026-02-04 17:27:55');
INSERT INTO `notifications` VALUES('57','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0009)','Hey Rose, you have received a new staff advance request(#0009) that needs your verification.','0','2026-02-04 17:29:24');
INSERT INTO `notifications` VALUES('58','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0010)','Hey Anthony, you have received a new petty cash requisition(#0010) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:33:54');
INSERT INTO `notifications` VALUES('59','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new petty cash requisition(#0010)','Hey Fumbani, you have received a new petty cash requisition(#0010) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:33:56');
INSERT INTO `notifications` VALUES('60','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0010)','Hey Kingsley, you have received a new petty cash requisition(#0010) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:02');
INSERT INTO `notifications` VALUES('61','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0010)','Hey Rose, you have received a new petty cash requisition(#0010) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:08');
INSERT INTO `notifications` VALUES('62','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0010)','Hey Emmanuel, you have received a new petty cash requisition(#0010) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:14');
INSERT INTO `notifications` VALUES('63','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0011)','Hey Anthony, you have received a new petty cash requisition(#0011) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:41');
INSERT INTO `notifications` VALUES('64','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new petty cash requisition(#0011)','Hey Fumbani, you have received a new petty cash requisition(#0011) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:43');
INSERT INTO `notifications` VALUES('65','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0011)','Hey Kingsley, you have received a new petty cash requisition(#0011) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:45');
INSERT INTO `notifications` VALUES('66','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0011)','Hey Rose, you have received a new petty cash requisition(#0011) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:47');
INSERT INTO `notifications` VALUES('67','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0011)','Hey Emmanuel, you have received a new petty cash requisition(#0011) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:49');
INSERT INTO `notifications` VALUES('68','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0012)','Hey Anthony, you have received a new petty cash requisition(#0012) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:51');
INSERT INTO `notifications` VALUES('69','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new petty cash requisition(#0012)','Hey Fumbani, you have received a new petty cash requisition(#0012) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:53');
INSERT INTO `notifications` VALUES('70','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0012)','Hey Kingsley, you have received a new petty cash requisition(#0012) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:55');
INSERT INTO `notifications` VALUES('71','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0012)','Hey Rose, you have received a new petty cash requisition(#0012) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:57');
INSERT INTO `notifications` VALUES('72','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0012)','Hey Emmanuel, you have received a new petty cash requisition(#0012) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:34:59');
INSERT INTO `notifications` VALUES('73','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0013)','Hey Anthony, you have received a new petty cash requisition(#0013) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:35:01');
INSERT INTO `notifications` VALUES('74','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new petty cash requisition(#0013)','Hey Fumbani, you have received a new petty cash requisition(#0013) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:35:03');
INSERT INTO `notifications` VALUES('75','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0013)','Hey Kingsley, you have received a new petty cash requisition(#0013) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:35:05');
INSERT INTO `notifications` VALUES('76','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0013)','Hey Rose, you have received a new petty cash requisition(#0013) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:35:07');
INSERT INTO `notifications` VALUES('77','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0013)','Hey Emmanuel, you have received a new petty cash requisition(#0013) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:35:10');
INSERT INTO `notifications` VALUES('78','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0014)','Hey Anthony, you have received a new petty cash requisition(#0014) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:36:25');
INSERT INTO `notifications` VALUES('79','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','RWM9poiBTms','You have received a new petty cash requisition(#0014)','Hey Fumbani, you have received a new petty cash requisition(#0014) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:36:27');
INSERT INTO `notifications` VALUES('80','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0014)','Hey Kingsley, you have received a new petty cash requisition(#0014) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:36:33');
INSERT INTO `notifications` VALUES('81','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0014)','Hey Rose, you have received a new petty cash requisition(#0014) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:36:39');
INSERT INTO `notifications` VALUES('82','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0014)','Hey Emmanuel, you have received a new petty cash requisition(#0014) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:36:45');
INSERT INTO `notifications` VALUES('83','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0015)','Hey Anthony, you have received a new petty cash requisition(#0015) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:39:38');
INSERT INTO `notifications` VALUES('84','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','RWM9poiBTms','You have received a new petty cash requisition(#0015)','Hey Fumbani, you have received a new petty cash requisition(#0015) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:39:40');
INSERT INTO `notifications` VALUES('85','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0015)','Hey Kingsley, you have received a new petty cash requisition(#0015) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:39:46');
INSERT INTO `notifications` VALUES('86','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0015)','Hey Rose, you have received a new petty cash requisition(#0015) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:39:52');
INSERT INTO `notifications` VALUES('87','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0015)','Hey Emmanuel, you have received a new petty cash requisition(#0015) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:39:58');
INSERT INTO `notifications` VALUES('88','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0010)','Hey Rose, you have received a new staff advance request(#0010) that needs your verification.','0','2026-02-04 17:40:41');
INSERT INTO `notifications` VALUES('89','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0016)','Hey Anthony, you have received a new petty cash requisition(#0016) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:50:05');
INSERT INTO `notifications` VALUES('90','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','RWM9poiBTms','You have received a new petty cash requisition(#0016)','Hey Fumbani, you have received a new petty cash requisition(#0016) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:50:08');
INSERT INTO `notifications` VALUES('91','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0016)','Hey Kingsley, you have received a new petty cash requisition(#0016) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:50:14');
INSERT INTO `notifications` VALUES('92','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0016)','Hey Rose, you have received a new petty cash requisition(#0016) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:50:20');
INSERT INTO `notifications` VALUES('93','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0016)','Hey Emmanuel, you have received a new petty cash requisition(#0016) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:50:26');
INSERT INTO `notifications` VALUES('94','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0017)','Hey Anthony, you have received a new petty cash requisition(#0017) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:51:46');
INSERT INTO `notifications` VALUES('95','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','RWM9poiBTms','You have received a new petty cash requisition(#0017)','Hey Fumbani, you have received a new petty cash requisition(#0017) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:51:48');
INSERT INTO `notifications` VALUES('96','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0017)','Hey Kingsley, you have received a new petty cash requisition(#0017) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:51:54');
INSERT INTO `notifications` VALUES('97','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0017)','Hey Rose, you have received a new petty cash requisition(#0017) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:52:00');
INSERT INTO `notifications` VALUES('98','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0017)','Hey Emmanuel, you have received a new petty cash requisition(#0017) that needs your attention, please log into the staff portal to check.','0','2026-02-04 17:52:06');
INSERT INTO `notifications` VALUES('99','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0011)','Hey Rose, you have received a new staff advance request(#0011) that needs your verification.','0','2026-02-04 17:52:45');
INSERT INTO `notifications` VALUES('100','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','RWM9poiBTms','You have received a new vehicle request to Authorize','Hey Fumbani, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-04 18:03:07');
INSERT INTO `notifications` VALUES('101','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','inAJsQeZy13r6c5xRI8i0','You have received a new vehicle request to Authorize','Hey Kingsley, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-04 18:03:09');
INSERT INTO `notifications` VALUES('102','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new vehicle request to Authorize','Hey Leroy, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-04 18:03:15');
INSERT INTO `notifications` VALUES('103','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','RWM9poiBTms','You have received a new vehicle request to Authorize','Hey Fumbani, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-04 18:05:13');
INSERT INTO `notifications` VALUES('104','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','inAJsQeZy13r6c5xRI8i0','You have received a new vehicle request to Authorize','Hey Kingsley, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-04 18:05:15');
INSERT INTO `notifications` VALUES('105','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new vehicle request to Authorize','Hey Leroy, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-04 18:05:21');
INSERT INTO `notifications` VALUES('106','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0011) to Approve','Hey Rose, you have received a new staff advance request(#0011) that needs your approval,  verify staff&apos;s previous advances before approval.','0','2026-02-04 18:50:51');
INSERT INTO `notifications` VALUES('107','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0011) to Approve','Hey Andole, you have received a new staff advance request(#0011) that needs your approval,  verify staff&apos;s previous advances before approval.','0','2026-02-04 18:50:53');
INSERT INTO `notifications` VALUES('108','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','RWM9poiBTms','You have received a new advance request(#0011) to approve','Hey Fumbani, you have received a new staff advance request(#0011) that needs your approval','0','2026-02-04 18:53:42');
INSERT INTO `notifications` VALUES('109','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','inAJsQeZy13r6c5xRI8i0','You have received a new advance request(#0011) to approve','Hey Kingsley, you have received a new staff advance request(#0011) that needs your approval','0','2026-02-04 18:53:44');
INSERT INTO `notifications` VALUES('110','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new advance request(#0011) to approve','Hey Leroy, you have received a new staff advance request(#0011) that needs your approval','0','2026-02-04 18:53:50');
INSERT INTO `notifications` VALUES('111','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','QWiEBixN9WstbEGkqEvp','You have received a new advance request(#0011) to approve','Hey Ezeckiel, you have received a new staff advance request(#0011) that needs your approval','0','2026-02-04 18:53:56');
INSERT INTO `notifications` VALUES('112','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0011) to approve','Hey Andole, you have received a new staff advance request(#0011) that needs your approval','0','2026-02-04 18:54:02');
INSERT INTO `notifications` VALUES('113','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0010) to Approve','Hey Rose, you have received a new staff advance request(#0010) that needs your approval,  verify staff&apos;s previous advances before approval.','0','2026-02-04 18:55:32');
INSERT INTO `notifications` VALUES('114','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0010) to Approve','Hey Andole, you have received a new staff advance request(#0010) that needs your approval,  verify staff&apos;s previous advances before approval.','0','2026-02-04 18:55:34');
INSERT INTO `notifications` VALUES('115','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','RWM9poiBTms','You have received a new advance request(#0010) to approve','Hey Fumbani, you have received a new staff advance request(#0010) that needs your approval','0','2026-02-04 18:56:12');
INSERT INTO `notifications` VALUES('116','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','inAJsQeZy13r6c5xRI8i0','You have received a new advance request(#0010) to approve','Hey Kingsley, you have received a new staff advance request(#0010) that needs your approval','0','2026-02-04 18:56:15');
INSERT INTO `notifications` VALUES('117','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new advance request(#0010) to approve','Hey Leroy, you have received a new staff advance request(#0010) that needs your approval','0','2026-02-04 18:56:21');
INSERT INTO `notifications` VALUES('118','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','QWiEBixN9WstbEGkqEvp','You have received a new advance request(#0010) to approve','Hey Ezeckiel, you have received a new staff advance request(#0010) that needs your approval','0','2026-02-04 18:56:27');
INSERT INTO `notifications` VALUES('119','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0010) to approve','Hey Andole, you have received a new staff advance request(#0010) that needs your approval','0','2026-02-04 18:56:33');
INSERT INTO `notifications` VALUES('120','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','YS3870fdsPY1LhX304','You have received a new leave application(#1) to verify','Hey Osley, Please go to &apos;Verify Leave&apos; section to verify the newly checked leave application','0','2026-02-04 18:59:59');
INSERT INTO `notifications` VALUES('121','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new leave application(#1) to verify','Hey Andole, Please go to &apos;Verify Leave&apos; section to verify the newly checked leave application','0','2026-02-04 19:00:01');
INSERT INTO `notifications` VALUES('122','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','YS3870fdsPY1LhX304','You have received a new leave application(#1) to verify','Hey Osley, Please go to &apos;Verify Leave&apos; section to verify the newly checked leave application','0','2026-02-04 19:00:07');
INSERT INTO `notifications` VALUES('123','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new leave application(#1) to verify','Hey Andole, Please go to &apos;Verify Leave&apos; section to verify the newly checked leave application','0','2026-02-04 19:00:13');
INSERT INTO `notifications` VALUES('124','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new leave application(#1) to approve','Hey Anthony, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-04 19:02:32');
INSERT INTO `notifications` VALUES('125','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','RWM9poiBTms','You have received a new leave application(#1) to approve','Hey Fumbani, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-04 19:02:34');
INSERT INTO `notifications` VALUES('126','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','inAJsQeZy13r6c5xRI8i0','You have received a new leave application(#1) to approve','Hey Kingsley, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-04 19:02:40');
INSERT INTO `notifications` VALUES('127','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new leave application(#1) to approve','Hey Leroy, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-04 19:02:46');
INSERT INTO `notifications` VALUES('128','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','QWiEBixN9WstbEGkqEvp','You have received a new leave application(#1) to approve','Hey Ezeckiel, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-04 19:02:52');
INSERT INTO `notifications` VALUES('129','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','cN7XJK4EJgIcFZ3P4pL','You have received a new leave application(#1) to approve','Hey Emmanuel, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-04 19:02:54');
INSERT INTO `notifications` VALUES('130','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new leave application(#1) to approve','Hey Andole, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-04 19:02:56');
INSERT INTO `notifications` VALUES('131','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new vehicle request for vehicle assignment','Hey Leroy, you have received a vehicle request that needs your attention. Please log into staff portal and check under Assign Vehicle to process.','0','2026-02-04 19:14:30');
INSERT INTO `notifications` VALUES('132','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new leave application(#2) to check','Hey Anthony, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-04 19:21:18');
INSERT INTO `notifications` VALUES('133','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','RWM9poiBTms','You have received a new leave application(#2) to check','Hey Fumbani, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-04 19:21:20');
INSERT INTO `notifications` VALUES('134','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','inAJsQeZy13r6c5xRI8i0','You have received a new leave application(#2) to check','Hey Kingsley, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-04 19:21:26');
INSERT INTO `notifications` VALUES('135','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new leave application(#2) to check','Hey Leroy, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-04 19:21:32');
INSERT INTO `notifications` VALUES('136','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','YS3870fdsPY1LhX304','You have received a new leave application(#2) to check','Hey Osley, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-04 19:21:38');
INSERT INTO `notifications` VALUES('137','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0009) to Approve','Hey Rose, you have received a new staff advance request(#0009) that needs your approval,  verify staff&apos;s previous advances before approval.','0','2026-02-05 07:07:58');
INSERT INTO `notifications` VALUES('138','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0009) to Approve','Hey Andole, you have received a new staff advance request(#0009) that needs your approval,  verify staff&apos;s previous advances before approval.','0','2026-02-05 07:07:58');
INSERT INTO `notifications` VALUES('139','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','RWM9poiBTms','You have received a new advance request(#0009) to approve','Hey Fumbani, you have received a new staff advance request(#0009) that needs your approval','0','2026-02-05 07:09:09');
INSERT INTO `notifications` VALUES('140','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','inAJsQeZy13r6c5xRI8i0','You have received a new advance request(#0009) to approve','Hey Kingsley, you have received a new staff advance request(#0009) that needs your approval','0','2026-02-05 07:09:10');
INSERT INTO `notifications` VALUES('141','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new advance request(#0009) to approve','Hey Leroy, you have received a new staff advance request(#0009) that needs your approval','0','2026-02-05 07:09:10');
INSERT INTO `notifications` VALUES('142','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','QWiEBixN9WstbEGkqEvp','You have received a new advance request(#0009) to approve','Hey Ezeckiel, you have received a new staff advance request(#0009) that needs your approval','0','2026-02-05 07:09:10');
INSERT INTO `notifications` VALUES('143','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0009) to approve','Hey Andole, you have received a new staff advance request(#0009) that needs your approval','0','2026-02-05 07:09:10');
INSERT INTO `notifications` VALUES('144','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','Your leave application(#1) has been approved','Hey Daniel, your leave application has been approved, the note(s) given are &apos;ok&apos;.','0','2026-02-05 15:28:43');
INSERT INTO `notifications` VALUES('145','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new leave application(#3) to check','Hey Andole, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 09:47:15');
INSERT INTO `notifications` VALUES('146','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new leave application(#3) to check','Hey Anthony, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 09:47:15');
INSERT INTO `notifications` VALUES('147','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','RWM9poiBTms','You have received a new leave application(#3) to check','Hey Fumbani, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 09:47:15');
INSERT INTO `notifications` VALUES('148','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','inAJsQeZy13r6c5xRI8i0','You have received a new leave application(#3) to check','Hey Kingsley, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 09:47:15');
INSERT INTO `notifications` VALUES('149','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new leave application(#3) to check','Hey Leroy, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 09:47:15');
INSERT INTO `notifications` VALUES('150','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','YS3870fdsPY1LhX304','You have received a new leave application(#3) to check','Hey Osley, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 09:47:15');
INSERT INTO `notifications` VALUES('151','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','You have received a new leave application(#3) to check','Hey Test, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 09:47:15');
INSERT INTO `notifications` VALUES('152','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','YS3870fdsPY1LhX304','You have received a new leave application(#3) to verify','Hey Osley, Please go to &apos;Verify Leave&apos; section to verify the newly checked leave application','0','2026-02-06 09:59:44');
INSERT INTO `notifications` VALUES('153','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new leave application(#3) to verify','Hey Andole, Please go to &apos;Verify Leave&apos; section to verify the newly checked leave application','0','2026-02-06 09:59:44');
INSERT INTO `notifications` VALUES('154','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new leave application(#3) to approve','Hey Anthony, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 10:06:33');
INSERT INTO `notifications` VALUES('155','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','RWM9poiBTms','You have received a new leave application(#3) to approve','Hey Fumbani, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 10:06:33');
INSERT INTO `notifications` VALUES('156','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','inAJsQeZy13r6c5xRI8i0','You have received a new leave application(#3) to approve','Hey Kingsley, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 10:06:33');
INSERT INTO `notifications` VALUES('157','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new leave application(#3) to approve','Hey Leroy, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 10:06:33');
INSERT INTO `notifications` VALUES('158','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','QWiEBixN9WstbEGkqEvp','You have received a new leave application(#3) to approve','Hey Ezeckiel, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 10:06:34');
INSERT INTO `notifications` VALUES('159','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','cN7XJK4EJgIcFZ3P4pL','You have received a new leave application(#3) to approve','Hey Emmanuel, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 10:06:34');
INSERT INTO `notifications` VALUES('160','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new leave application(#3) to approve','Hey Andole, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 10:06:34');
INSERT INTO `notifications` VALUES('161','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','You have received a new leave application(#3) to approve','Hey Test, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 10:06:34');
INSERT INTO `notifications` VALUES('162','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','Your leave application(#3) has been approved','Hey Wezzie, your leave application has been approved, the note(s) given are &apos;Its approved.&apos;.','0','2026-02-06 10:07:09');
INSERT INTO `notifications` VALUES('163','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new leave application(#4) to check','Hey Andole, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 10:53:00');
INSERT INTO `notifications` VALUES('164','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new leave application(#4) to check','Hey Anthony, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 10:53:00');
INSERT INTO `notifications` VALUES('165','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','RWM9poiBTms','You have received a new leave application(#4) to check','Hey Fumbani, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 10:53:00');
INSERT INTO `notifications` VALUES('166','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','inAJsQeZy13r6c5xRI8i0','You have received a new leave application(#4) to check','Hey Kingsley, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 10:53:00');
INSERT INTO `notifications` VALUES('167','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new leave application(#4) to check','Hey Leroy, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 10:53:00');
INSERT INTO `notifications` VALUES('168','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','YS3870fdsPY1LhX304','You have received a new leave application(#4) to check','Hey Osley, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 10:53:00');
INSERT INTO `notifications` VALUES('169','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','Your leave application(#2) has been denied','Hey Andole, your leave application has been denied, the reason(s) given are &apos;All is good, he can go&apos;.','0','2026-02-06 11:05:17');
INSERT INTO `notifications` VALUES('170','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0012)','Hey Rose, you have received a new staff advance request(#0012) that needs your verification.','0','2026-02-06 11:08:24');
INSERT INTO `notifications` VALUES('171','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0012)','Hey Andole, you have received a new staff advance request(#0012) that needs your verification.','0','2026-02-06 11:08:24');
INSERT INTO `notifications` VALUES('172','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','Your staff advance request(#0011) has been Approved','Hey Wezzie, your advance request(#0011) that you posted has been Approved, go to details to check the update','0','2026-02-06 11:10:56');
INSERT INTO `notifications` VALUES('173','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','Your staff advance request(#0010) has been Approved','Hey Wezzie, your advance request(#0010) that you posted has been Approved, go to details to check the update','0','2026-02-06 11:12:51');
INSERT INTO `notifications` VALUES('174','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0018)','Hey Anthony, you have received a new petty cash requisition(#0018) that needs your attention, please log into the staff portal to check.','0','2026-02-06 11:15:20');
INSERT INTO `notifications` VALUES('175','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','RWM9poiBTms','You have received a new petty cash requisition(#0018)','Hey Fumbani, you have received a new petty cash requisition(#0018) that needs your attention, please log into the staff portal to check.','0','2026-02-06 11:15:20');
INSERT INTO `notifications` VALUES('176','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0018)','Hey Kingsley, you have received a new petty cash requisition(#0018) that needs your attention, please log into the staff portal to check.','0','2026-02-06 11:15:20');
INSERT INTO `notifications` VALUES('177','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0018)','Hey Rose, you have received a new petty cash requisition(#0018) that needs your attention, please log into the staff portal to check.','0','2026-02-06 11:15:20');
INSERT INTO `notifications` VALUES('178','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0018)','Hey Emmanuel, you have received a new petty cash requisition(#0018) that needs your attention, please log into the staff portal to check.','0','2026-02-06 11:15:20');
INSERT INTO `notifications` VALUES('179','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new petty cash requisition(#0018)','Hey Andole, you have received a new petty cash requisition(#0018) that needs your attention, please log into the staff portal to check.','0','2026-02-06 11:15:20');
INSERT INTO `notifications` VALUES('180','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','RWM9poiBTms','You have received a new vehicle request to Authorize','Hey Fumbani, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-06 11:24:49');
INSERT INTO `notifications` VALUES('181','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','inAJsQeZy13r6c5xRI8i0','You have received a new vehicle request to Authorize','Hey Kingsley, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-06 11:24:49');
INSERT INTO `notifications` VALUES('182','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new vehicle request to Authorize','Hey Leroy, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-06 11:24:49');
INSERT INTO `notifications` VALUES('183','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new vehicle request to Authorize','Hey Andole, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-06 11:24:49');
INSERT INTO `notifications` VALUES('184','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0007)','Hey Rose, you have received a new staff advance request(#0007) that needs your verification.','0','2026-02-06 11:32:48');
INSERT INTO `notifications` VALUES('185','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0007)','Hey Andole, you have received a new staff advance request(#0007) that needs your verification.','0','2026-02-06 11:32:48');
INSERT INTO `notifications` VALUES('186','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','001','Your travel advance request has been Approved','Hey, your travel advance request that you posted has been Approved, go to details to check the update','0','2026-02-06 11:38:30');
INSERT INTO `notifications` VALUES('187','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','001','Your travel advance request has been Approved','Hey, your travel advance request that you posted has been Approved, go to details to check the update','0','2026-02-06 11:48:28');
INSERT INTO `notifications` VALUES('188','m2qYOyqKVKErImdlwCImuwgg','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0019)','Hey Anthony, you have received a new petty cash requisition(#0019) that needs your attention, please log into the staff portal to check.','0','2026-02-06 14:12:47');
INSERT INTO `notifications` VALUES('189','m2qYOyqKVKErImdlwCImuwgg','RWM9poiBTms','You have received a new petty cash requisition(#0019)','Hey Fumbani, you have received a new petty cash requisition(#0019) that needs your attention, please log into the staff portal to check.','0','2026-02-06 14:12:47');
INSERT INTO `notifications` VALUES('190','m2qYOyqKVKErImdlwCImuwgg','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0019)','Hey Kingsley, you have received a new petty cash requisition(#0019) that needs your attention, please log into the staff portal to check.','0','2026-02-06 14:12:47');
INSERT INTO `notifications` VALUES('191','m2qYOyqKVKErImdlwCImuwgg','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0019)','Hey Rose, you have received a new petty cash requisition(#0019) that needs your attention, please log into the staff portal to check.','0','2026-02-06 14:12:47');
INSERT INTO `notifications` VALUES('192','m2qYOyqKVKErImdlwCImuwgg','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0019)','Hey Emmanuel, you have received a new petty cash requisition(#0019) that needs your attention, please log into the staff portal to check.','0','2026-02-06 14:12:47');
INSERT INTO `notifications` VALUES('193','m2qYOyqKVKErImdlwCImuwgg','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new petty cash requisition(#0019)','Hey Andole, you have received a new petty cash requisition(#0019) that needs your attention, please log into the staff portal to check.','0','2026-02-06 14:12:47');
INSERT INTO `notifications` VALUES('194','m2qYOyqKVKErImdlwCImuwgg','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new leave application(#5) to check','Hey Andole, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 14:21:20');
INSERT INTO `notifications` VALUES('195','m2qYOyqKVKErImdlwCImuwgg','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new leave application(#5) to check','Hey Anthony, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 14:21:20');
INSERT INTO `notifications` VALUES('196','m2qYOyqKVKErImdlwCImuwgg','RWM9poiBTms','You have received a new leave application(#5) to check','Hey Fumbani, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 14:21:20');
INSERT INTO `notifications` VALUES('197','m2qYOyqKVKErImdlwCImuwgg','inAJsQeZy13r6c5xRI8i0','You have received a new leave application(#5) to check','Hey Kingsley, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 14:21:20');
INSERT INTO `notifications` VALUES('198','m2qYOyqKVKErImdlwCImuwgg','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new leave application(#5) to check','Hey Leroy, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 14:21:20');
INSERT INTO `notifications` VALUES('199','m2qYOyqKVKErImdlwCImuwgg','YS3870fdsPY1LhX304','You have received a new leave application(#5) to check','Hey Osley, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 14:21:20');
INSERT INTO `notifications` VALUES('200','m2qYOyqKVKErImdlwCImuwgg','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','You have received a new leave application(#5) to check','Hey Test, Please go to &apos;Check Leave&apos; section to check the newly posted leave application','0','2026-02-06 14:21:20');
INSERT INTO `notifications` VALUES('201','m2qYOyqKVKErImdlwCImuwgg','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0013)','Hey Rose, you have received a new staff advance request(#0013) that needs your verification.','0','2026-02-06 14:22:16');
INSERT INTO `notifications` VALUES('202','m2qYOyqKVKErImdlwCImuwgg','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0013)','Hey Andole, you have received a new staff advance request(#0013) that needs your verification.','0','2026-02-06 14:22:16');
INSERT INTO `notifications` VALUES('203','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','YS3870fdsPY1LhX304','You have received a new leave application(#5) to verify','Hey Osley, Please go to &apos;Verify Leave&apos; section to verify the newly checked leave application','0','2026-02-06 14:23:04');
INSERT INTO `notifications` VALUES('204','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new leave application(#5) to verify','Hey Andole, Please go to &apos;Verify Leave&apos; section to verify the newly checked leave application','0','2026-02-06 14:23:04');
INSERT INTO `notifications` VALUES('205','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','You have received a new leave application(#5) to verify','Hey Test, Please go to &apos;Verify Leave&apos; section to verify the newly checked leave application','0','2026-02-06 14:23:04');
INSERT INTO `notifications` VALUES('206','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','m2qYOyqKVKErImdlwCImuwgg','Your petty cash requisition(#0019) has been Approved','Hey Martha, your petty cash requisition(#0019) that you posted has been Approved, go to details to check the update','0','2026-02-06 14:23:29');
INSERT INTO `notifications` VALUES('207','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new leave application(#5) to approve','Hey Anthony, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 14:25:53');
INSERT INTO `notifications` VALUES('208','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','RWM9poiBTms','You have received a new leave application(#5) to approve','Hey Fumbani, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 14:25:53');
INSERT INTO `notifications` VALUES('209','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','inAJsQeZy13r6c5xRI8i0','You have received a new leave application(#5) to approve','Hey Kingsley, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 14:25:53');
INSERT INTO `notifications` VALUES('210','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new leave application(#5) to approve','Hey Leroy, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 14:25:53');
INSERT INTO `notifications` VALUES('211','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','QWiEBixN9WstbEGkqEvp','You have received a new leave application(#5) to approve','Hey Ezeckiel, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 14:25:53');
INSERT INTO `notifications` VALUES('212','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','cN7XJK4EJgIcFZ3P4pL','You have received a new leave application(#5) to approve','Hey Emmanuel, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 14:25:53');
INSERT INTO `notifications` VALUES('213','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new leave application(#5) to approve','Hey Andole, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 14:25:53');
INSERT INTO `notifications` VALUES('214','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','You have received a new leave application(#5) to approve','Hey Test, Please go to &apos;Approve Leave&apos; section to approve the newly verified leave application','0','2026-02-06 14:25:53');
INSERT INTO `notifications` VALUES('215','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','m2qYOyqKVKErImdlwCImuwgg','Your leave application(#5) has been approved','Hey Martha, your leave application has been approved, the note(s) given are &apos;ok&apos;.','0','2026-02-06 14:26:49');
INSERT INTO `notifications` VALUES('216','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0013) to Approve','Hey Rose, you have received a new staff advance request(#0013) that needs your approval,  verify staff&apos;s previous advances before approval.','0','2026-02-06 14:27:51');
INSERT INTO `notifications` VALUES('217','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0013) to Approve','Hey Andole, you have received a new staff advance request(#0013) that needs your approval,  verify staff&apos;s previous advances before approval.','0','2026-02-06 14:27:51');
INSERT INTO `notifications` VALUES('218','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','RWM9poiBTms','You have received a new advance request(#0013) to approve','Hey Fumbani, you have received a new staff advance request(#0013) that needs your approval','0','2026-02-06 14:28:04');
INSERT INTO `notifications` VALUES('219','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','inAJsQeZy13r6c5xRI8i0','You have received a new advance request(#0013) to approve','Hey Kingsley, you have received a new staff advance request(#0013) that needs your approval','0','2026-02-06 14:28:04');
INSERT INTO `notifications` VALUES('220','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new advance request(#0013) to approve','Hey Leroy, you have received a new staff advance request(#0013) that needs your approval','0','2026-02-06 14:28:04');
INSERT INTO `notifications` VALUES('221','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','QWiEBixN9WstbEGkqEvp','You have received a new advance request(#0013) to approve','Hey Ezeckiel, you have received a new staff advance request(#0013) that needs your approval','0','2026-02-06 14:28:04');
INSERT INTO `notifications` VALUES('222','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0013) to approve','Hey Andole, you have received a new staff advance request(#0013) that needs your approval','0','2026-02-06 14:28:04');
INSERT INTO `notifications` VALUES('223','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','You have received a new advance request(#0013) to approve','Hey Test, you have received a new staff advance request(#0013) that needs your approval','0','2026-02-06 14:28:04');
INSERT INTO `notifications` VALUES('224','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0020)','Hey Anthony, you have received a new petty cash requisition(#0020) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:37:32');
INSERT INTO `notifications` VALUES('225','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new petty cash requisition(#0020)','Hey Fumbani, you have received a new petty cash requisition(#0020) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:37:32');
INSERT INTO `notifications` VALUES('226','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0020)','Hey Kingsley, you have received a new petty cash requisition(#0020) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:37:32');
INSERT INTO `notifications` VALUES('227','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0020)','Hey Rose, you have received a new petty cash requisition(#0020) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:37:32');
INSERT INTO `notifications` VALUES('228','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0020)','Hey Emmanuel, you have received a new petty cash requisition(#0020) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:37:32');
INSERT INTO `notifications` VALUES('229','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new petty cash requisition(#0020)','Hey Andole, you have received a new petty cash requisition(#0020) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:37:32');
INSERT INTO `notifications` VALUES('230','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','You have received a new petty cash requisition(#0021)','Hey Anthony, you have received a new petty cash requisition(#0021) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:42:15');
INSERT INTO `notifications` VALUES('231','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new petty cash requisition(#0021)','Hey Fumbani, you have received a new petty cash requisition(#0021) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:42:15');
INSERT INTO `notifications` VALUES('232','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new petty cash requisition(#0021)','Hey Kingsley, you have received a new petty cash requisition(#0021) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:42:15');
INSERT INTO `notifications` VALUES('233','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new petty cash requisition(#0021)','Hey Rose, you have received a new petty cash requisition(#0021) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:42:15');
INSERT INTO `notifications` VALUES('234','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','cN7XJK4EJgIcFZ3P4pL','You have received a new petty cash requisition(#0021)','Hey Emmanuel, you have received a new petty cash requisition(#0021) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:42:15');
INSERT INTO `notifications` VALUES('235','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new petty cash requisition(#0021)','Hey Andole, you have received a new petty cash requisition(#0021) that needs your attention, please log into the staff portal to check.','0','2026-02-07 00:42:15');
INSERT INTO `notifications` VALUES('236','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0014)','Hey Rose, you have received a new staff advance request(#0014) that needs your verification.','0','2026-02-07 00:47:20');
INSERT INTO `notifications` VALUES('237','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0014)','Hey Andole, you have received a new staff advance request(#0014) that needs your verification.','0','2026-02-07 00:47:20');
INSERT INTO `notifications` VALUES('238','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','FtFFeM1Yb17UWcqIqodm4csT','You have received a new advance request(#0014) to Approve','Hey Rose, you have received a new staff advance request(#0014) that needs your approval,  verify staff&apos;s previous advances before approval.','0','2026-02-07 02:05:06');
INSERT INTO `notifications` VALUES('239','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0014) to Approve','Hey Andole, you have received a new staff advance request(#0014) that needs your approval,  verify staff&apos;s previous advances before approval.','0','2026-02-07 02:05:06');
INSERT INTO `notifications` VALUES('240','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','RWM9poiBTms','You have received a new advance request(#0014) to approve','Hey Fumbani, you have received a new staff advance request(#0014) that needs your approval','0','2026-02-07 02:06:25');
INSERT INTO `notifications` VALUES('241','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','inAJsQeZy13r6c5xRI8i0','You have received a new advance request(#0014) to approve','Hey Kingsley, you have received a new staff advance request(#0014) that needs your approval','0','2026-02-07 02:06:25');
INSERT INTO `notifications` VALUES('242','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new advance request(#0014) to approve','Hey Leroy, you have received a new staff advance request(#0014) that needs your approval','0','2026-02-07 02:06:25');
INSERT INTO `notifications` VALUES('243','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','QWiEBixN9WstbEGkqEvp','You have received a new advance request(#0014) to approve','Hey Ezeckiel, you have received a new staff advance request(#0014) that needs your approval','0','2026-02-07 02:06:25');
INSERT INTO `notifications` VALUES('244','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new advance request(#0014) to approve','Hey Andole, you have received a new staff advance request(#0014) that needs your approval','0','2026-02-07 02:06:25');
INSERT INTO `notifications` VALUES('245','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','You have received a new advance request(#0014) to approve','Hey Test, you have received a new staff advance request(#0014) that needs your approval','0','2026-02-07 02:06:25');
INSERT INTO `notifications` VALUES('246','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new vehicle request to Authorize','Hey Fumbani, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:11:15');
INSERT INTO `notifications` VALUES('247','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new vehicle request to Authorize','Hey Kingsley, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:11:15');
INSERT INTO `notifications` VALUES('248','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new vehicle request to Authorize','Hey Leroy, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:11:15');
INSERT INTO `notifications` VALUES('249','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new vehicle request to Authorize','Hey Andole, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:11:15');
INSERT INTO `notifications` VALUES('250','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','RWM9poiBTms','You have received a new vehicle request to Authorize','Hey Fumbani, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:19:11');
INSERT INTO `notifications` VALUES('251','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','inAJsQeZy13r6c5xRI8i0','You have received a new vehicle request to Authorize','Hey Kingsley, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:19:11');
INSERT INTO `notifications` VALUES('252','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new vehicle request to Authorize','Hey Leroy, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:19:11');
INSERT INTO `notifications` VALUES('253','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','RWM9poiBTms','You have received a new vehicle request to Authorize','Hey Fumbani, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:21:33');
INSERT INTO `notifications` VALUES('254','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','inAJsQeZy13r6c5xRI8i0','You have received a new vehicle request to Authorize','Hey Kingsley, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:21:33');
INSERT INTO `notifications` VALUES('255','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new vehicle request to Authorize','Hey Leroy, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:21:33');
INSERT INTO `notifications` VALUES('256','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new vehicle request to Authorize','Hey Andole, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:21:33');
INSERT INTO `notifications` VALUES('257','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new vehicle request for vehicle assignment','Hey Leroy, you have received a vehicle request that needs your attention. Please log into staff portal and check under Assign Vehicle to process.','0','2026-02-07 07:23:27');
INSERT INTO `notifications` VALUES('258','m2qYOyqKVKErImdlwCImuwgg','RWM9poiBTms','You have received a new vehicle request to Authorize','Hey Fumbani, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:35:19');
INSERT INTO `notifications` VALUES('259','m2qYOyqKVKErImdlwCImuwgg','inAJsQeZy13r6c5xRI8i0','You have received a new vehicle request to Authorize','Hey Kingsley, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:35:19');
INSERT INTO `notifications` VALUES('260','m2qYOyqKVKErImdlwCImuwgg','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new vehicle request to Authorize','Hey Leroy, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:35:19');
INSERT INTO `notifications` VALUES('261','m2qYOyqKVKErImdlwCImuwgg','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','You have received a new vehicle request to Authorize','Hey Andole, you have received a vehicle request that needs your attention. Please log into staff portal and check under Authorize Request to process.','0','2026-02-07 07:35:19');
INSERT INTO `notifications` VALUES('262','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','You have received a new vehicle request for vehicle assignment','Hey Leroy, you have received a vehicle request that needs your attention. Please log into staff portal and check under Assign Vehicle to process.','0','2026-02-07 07:36:19');
DROP TABLE IF EXISTS `permissions`;

CREATE TABLE `permissions` (
  `permission_id` int(11) NOT NULL AUTO_INCREMENT,
  `permission` varchar(128) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`permission_id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `permissions` VALUES('1','Super User','This permission allows the user to have access to every functionality of the system and it should be given to the IT Admin of this system.');
INSERT INTO `permissions` VALUES('2','Sacco Administrator','This permission is given to the IT Administrator of a Sacco, to manage Sacco Members and everything that 
Sacco is allowed to access.');
INSERT INTO `permissions` VALUES('3','Manage Invoices','This permission allows the member to post and update the status of the invoice. ');
INSERT INTO `permissions` VALUES('4','Manage Events','This permission allows the member to post and update events.');
INSERT INTO `permissions` VALUES('5','Manage Documents','This permission allows the member to post and update document directory.');
INSERT INTO `permissions` VALUES('6','Check Leave','This permission allows the user to check leave application before it goes to admin for verification, probably is the head of section.');
INSERT INTO `permissions` VALUES('7','Approve Leave','This permission allows the user to approve or decline a leave application, this is the CEO.');
INSERT INTO `permissions` VALUES('8','Manage Leave','This permission allows the user to manage employee's leave days at the start of every FY, confirm if leave grant is required and verify if the leave application details are correct before it goes for approval.');
INSERT INTO `permissions` VALUES('9','Manage Loans','This permission allows the user to manage loan applications from Sacco or the Sacco representative who handles loans.');
INSERT INTO `permissions` VALUES('10','Check Vehicle Request','This permission allows the user to check vehicle request and assigns the required vehicle. Also, they check the condition of the vehicle, fuel levels and tools included in the vehicle.');
INSERT INTO `permissions` VALUES('11','Authorize Vehicle Request','This permission allows the user to authorize the vehicle.');
INSERT INTO `permissions` VALUES('12','Approve Petty Cash','This permission allows the user to approve or decline a petty cash requisitions ');
INSERT INTO `permissions` VALUES('13','Verify Advance','This permission allows the user to approve or decline a advance request, this is someone in the accounts department.');
INSERT INTO `permissions` VALUES('14','Check Advance','This permission allows the user to check an advance request, this is the supervisor.');
INSERT INTO `permissions` VALUES('15','Approve Advance','This permission allows the user to approve or decline an advance request, this is the CE.');
INSERT INTO `permissions` VALUES('16','Manage Employees','This permission allows the HR to manage different parameters of the employees.');
INSERT INTO `permissions` VALUES('17','Check Travel Advance Request','This permission allows the user to check  user travel advance request, this is the supervisor.');
INSERT INTO `permissions` VALUES('18','Approve Travel Advance Request','This permission allows the user to approve user travel advance request, this is the snr management.');
INSERT INTO `permissions` VALUES('19','View Reports','Allows the user to view different reports.');
DROP TABLE IF EXISTS `permissions_granted`;

CREATE TABLE `permissions_granted` (
  `granted_id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` varchar(60) NOT NULL,
  `permission_id` int(11) NOT NULL,
  `date_assigned` timestamp NOT NULL DEFAULT current_timestamp(),
  `assigned_by` varchar(60) NOT NULL,
  PRIMARY KEY (`granted_id`)
) ENGINE=InnoDB AUTO_INCREMENT=107 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `permissions_granted` VALUES('1','1k0pqp7qI8gI','16','2023-11-05 13:08:34','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('2','1k0pqp7qI8gI','12','2023-11-08 13:33:03','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('3','1k0pqp7qI8gI','13','2023-11-09 14:48:19','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('4','1k0pqp7qI8gI','14','2023-11-09 14:48:22','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('5','1k0pqp7qI8gI','15','2023-11-09 14:48:45','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('6','1k0pqp7qI8gI','17','2023-11-10 19:37:20','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('7','1k0pqp7qI8gI','18','2023-11-10 19:37:39','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('8','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','1','2023-11-10 20:00:42','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('9','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','2023-11-24 23:44:14','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('10','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','6','2023-11-27 09:39:30','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('11','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','4','2023-11-27 09:40:01','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('12','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','5','2023-11-27 09:40:25','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('13','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','10','2023-11-27 09:40:48','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('14','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','16','2023-11-27 09:41:24','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('15','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','19','2023-11-27 09:41:41','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('16','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','5','2023-12-19 02:29:14','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('17','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','6','2023-12-19 02:29:28','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('18','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','7','2023-12-19 02:29:44','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('19','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','12','2023-12-19 02:30:11','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('20','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','19','2023-12-19 02:30:34','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('21','havCLHBjolrH5wI6cnP3UyAqHKvS3kC6thavU4pD8vW0qh0vuJCTYGDU','19','2023-12-19 02:31:10','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('22','cN7XJK4EJgIcFZ3P4pL','19','2023-12-19 02:32:08','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('23','RWM9poiBTms','5','2023-12-19 02:32:34','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('24','RWM9poiBTms','6','2023-12-19 02:32:51','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('25','RWM9poiBTms','7','2023-12-19 02:33:04','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('26','RWM9poiBTms','11','2023-12-19 02:33:26','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('27','RWM9poiBTms','12','2023-12-19 02:33:41','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('28','RWM9poiBTms','15','2023-12-19 02:34:04','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('29','RWM9poiBTms','18','2023-12-19 02:34:19','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('30','RWM9poiBTms','19','2023-12-19 02:34:34','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('31','inAJsQeZy13r6c5xRI8i0','3','2023-12-19 02:35:33','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('32','inAJsQeZy13r6c5xRI8i0','4','2023-12-19 02:35:51','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('33','inAJsQeZy13r6c5xRI8i0','6','2023-12-19 02:36:48','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('34','inAJsQeZy13r6c5xRI8i0','7','2023-12-19 02:36:59','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('35','inAJsQeZy13r6c5xRI8i0','11','2023-12-19 02:37:23','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('36','inAJsQeZy13r6c5xRI8i0','12','2023-12-19 02:37:35','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('37','inAJsQeZy13r6c5xRI8i0','15','2023-12-19 02:37:48','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('38','inAJsQeZy13r6c5xRI8i0','18','2023-12-19 02:38:00','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('39','inAJsQeZy13r6c5xRI8i0','19','2023-12-19 02:38:11','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('40','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','5','2023-12-19 02:38:42','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('41','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','6','2023-12-19 02:38:53','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('42','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','7','2023-12-19 02:39:04','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('43','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','10','2023-12-19 02:39:18','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('44','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','11','2023-12-19 02:39:30','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('45','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','15','2023-12-19 02:39:48','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('46','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','17','2023-12-19 02:40:03','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('47','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','18','2023-12-19 02:40:14','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('48','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','19','2023-12-19 02:40:26','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('49','2nK9f2qboFJYiMJcJoTWQXccS6TcrtKtX8I','19','2023-12-19 02:40:53','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('50','lTYqrrnO3Qpi4Q','19','2023-12-19 02:41:38','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('51','lTYqrrnO3Qpi4Q','9','2023-12-19 02:41:51','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('52','lTYqrrnO3Qpi4Q','3','2023-12-19 02:42:02','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('53','FtFFeM1Yb17UWcqIqodm4csT','3','2023-12-19 02:42:34','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('54','FtFFeM1Yb17UWcqIqodm4csT','9','2023-12-19 02:42:48','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('55','FtFFeM1Yb17UWcqIqodm4csT','12','2023-12-19 02:43:05','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('56','FtFFeM1Yb17UWcqIqodm4csT','13','2023-12-19 02:43:27','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('57','FtFFeM1Yb17UWcqIqodm4csT','14','2023-12-19 02:43:40','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('58','FtFFeM1Yb17UWcqIqodm4csT','19','2023-12-19 02:43:57','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('59','vRrjIqmw9m5lM4sorbq7R2','19','2023-12-19 02:44:22','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('60','vRrjIqmw9m5lM4sorbq7R2','3','2023-12-19 02:44:32','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('61','vRrjIqmw9m5lM4sorbq7R2','9','2023-12-19 02:44:47','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('62','IIXiuVLQbocEsCBidtKrqGQl6WtTm','19','2023-12-19 03:55:49','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('64','QWiEBixN9WstbEGkqEvp','3','2023-12-19 07:39:19','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('66','QWiEBixN9WstbEGkqEvp','7','2023-12-19 07:40:02','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('67','QWiEBixN9WstbEGkqEvp','15','2023-12-19 07:40:29','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('68','YS3870fdsPY1LhX304','8','2024-01-08 04:46:07','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('69','YS3870fdsPY1LhX304','6','2024-01-08 04:46:22','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('70','YS3870fdsPY1LhX304','3','2024-01-08 04:46:33','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('71','YS3870fdsPY1LhX304','16','2024-01-08 04:46:51','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('72','YS3870fdsPY1LhX304','19','2024-01-08 04:47:05','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('73','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','8','2024-01-11 13:02:14','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('74','bLeN6m76QH8z','3','2024-01-16 04:45:10','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('75','bLeN6m76QH8z','9','2024-01-16 04:45:27','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('76','bLeN6m76QH8z','19','2024-01-16 04:45:53','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('77','bLeN6m76QH8z','5','2024-01-16 04:46:05','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('78','bLeN6m76QH8z','6','2024-01-16 04:46:16','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('79','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','2','2024-01-22 03:58:11','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('80','cN7XJK4EJgIcFZ3P4pL','3','2024-01-24 02:08:09','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('81','cN7XJK4EJgIcFZ3P4pL','7','2024-01-24 02:08:22','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('82','cN7XJK4EJgIcFZ3P4pL','9','2024-01-24 02:08:38','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('83','cN7XJK4EJgIcFZ3P4pL','12','2024-01-24 02:09:05','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('84','QWiEBixN9WstbEGkqEvp','5','2024-09-20 13:46:05','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('85','QWiEBixN9WstbEGkqEvp','19','2024-09-20 13:46:50','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('86','QWiEBixN9WstbEGkqEvp','1','2024-09-20 13:54:56','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('87','havCLHBjolrH5wI6cnP3UyAqHKvS3kC6thavU4pD8vW0qh0vuJCTYGDU','1','2025-01-14 07:31:40','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('88','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','7','2026-02-04 18:16:02','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('89','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','3','2026-02-04 18:16:17','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('90','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2','2026-02-04 18:16:32','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('91','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','11','2026-02-04 18:17:08','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('92','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','9','2026-02-04 18:17:23','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('93','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','17','2026-02-04 18:17:48','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('94','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','18','2026-02-04 18:17:52','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('95','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','12','2026-02-04 18:18:02','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('96','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','13','2026-02-04 18:18:32','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('97','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','15','2026-02-04 18:18:48','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('98','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','14','2026-02-04 18:18:51','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('99','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','6','2026-02-06 09:42:11','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('100','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','16','2026-02-06 09:44:36','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('101','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','7','2026-02-06 10:01:35','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('102','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','8','2026-02-06 10:04:16','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('103','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','15','2026-02-06 10:05:14','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh');
INSERT INTO `permissions_granted` VALUES('104','m2qYOyqKVKErImdlwCImuwgg','3','2026-02-06 13:58:04','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('105','m2qYOyqKVKErImdlwCImuwgg','19','2026-02-06 13:58:38','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
INSERT INTO `permissions_granted` VALUES('106','m2qYOyqKVKErImdlwCImuwgg','5','2026-02-06 13:59:03','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3');
DROP TABLE IF EXISTS `petty_cash_requisitions`;

CREATE TABLE `petty_cash_requisitions` (
  `requisition_id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_by` varchar(60) NOT NULL,
  `department_id` int(11) NOT NULL,
  `subject` varchar(1028) NOT NULL,
  `sponsor` varchar(128) NOT NULL,
  `amount` double NOT NULL,
  `description` varchar(1028) NOT NULL,
  `date_posted` timestamp NOT NULL DEFAULT current_timestamp(),
  `requisition_status` int(11) NOT NULL DEFAULT 0,
  `approved_by` varchar(60) DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `date_approved` date DEFAULT NULL,
  PRIMARY KEY (`requisition_id`)
) ENGINE=InnoDB AUTO_INCREMENT=22 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `petty_cash_requisitions` VALUES('1','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','1','Lunch Allowances','MUSCCO','1000','For lunch','2023-11-08 13:28:32','1','1k0pqp7qI8gI','No problem','2023-11-08');
INSERT INTO `petty_cash_requisitions` VALUES('4','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','Meal','MUSCCO','10000','Meal for attending AGM','2024-09-20 13:05:08','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('5','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','Hungry Lion','MLBP','10000','Pizza for working late','2024-11-07 02:20:41','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('9','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','1','Test Petty Cash','MUSCCO','1000','This is a test requisition..','2024-11-11 03:27:48','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('10','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','Lunch guys','MUSCCO','8000','Lunch for training','2026-02-04 17:33:54','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('11','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','Lunch guys','MUSCCO','8000','Lunch for training','2026-02-04 17:34:41','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('12','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','Lunch guys','MUSCCO','8000','Lunch for training','2026-02-04 17:34:51','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('13','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','Lunch guys','MUSCCO','8000','Lunch for training','2026-02-04 17:35:01','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('14','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','1','LUNCH','Timotheous','800','OK','2026-02-04 17:36:25','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('15','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','1','Enquiry','Timotheous','7000','OK','2026-02-04 17:39:38','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('16','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','1','dinner','mmuscco','3000','ok','2026-02-04 17:50:05','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('17','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','1','Cash OB','Timotheous','78','ok','2026-02-04 17:51:46','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('18','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','20','hghg','uyu','5000','hello','2026-02-06 11:15:20','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('19','m2qYOyqKVKErImdlwCImuwgg','20','Cash OB','Timotheous','10000','Lunch','2026-02-06 14:12:47','1','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','ok','2026-02-06');
INSERT INTO `petty_cash_requisitions` VALUES('20','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','Lunch for two','RBM','10000','Lunch for two','2026-02-07 00:37:32','0','','','');
INSERT INTO `petty_cash_requisitions` VALUES('21','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','1','Cash OB','tt','1000','ok','2026-02-07 00:42:15','0','','','');
DROP TABLE IF EXISTS `pillars`;

CREATE TABLE `pillars` (
  `pillar_id` int(11) NOT NULL AUTO_INCREMENT,
  `pillar` varchar(128) NOT NULL,
  PRIMARY KEY (`pillar_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `pillars` VALUES('1','Central Finance facility	
');
INSERT INTO `pillars` VALUES('2','Corporate Governance');
INSERT INTO `pillars` VALUES('3','Corporate Services ');
INSERT INTO `pillars` VALUES('4','Deepened Corporate Model');
DROP TABLE IF EXISTS `positions`;

CREATE TABLE `positions` (
  `position_id` int(11) NOT NULL AUTO_INCREMENT,
  `position` varchar(1028) NOT NULL,
  `member_of` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`position_id`)
) ENGINE=InnoDB AUTO_INCREMENT=75 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci COMMENT='Stores Sacco and Muscco Positions';
INSERT INTO `positions` VALUES('1','System Administrator','0');
INSERT INTO `positions` VALUES('2','Secretary','0');
INSERT INTO `positions` VALUES('3','Driver','0');
INSERT INTO `positions` VALUES('4','Business Development Officer','0');
INSERT INTO `positions` VALUES('15','Auditor','0');
INSERT INTO `positions` VALUES('17','Executive Director','0');
INSERT INTO `positions` VALUES('33','Internal Auditor','0');
INSERT INTO `positions` VALUES('34','Business Development Manager','0');
INSERT INTO `positions` VALUES('35','Finance Manager','0');
INSERT INTO `positions` VALUES('36','Monitoring and Evaluation Officer','0');
INSERT INTO `positions` VALUES('37','Administrative Assistant','0');
INSERT INTO `positions` VALUES('38','Accounts Assistant','0');
INSERT INTO `positions` VALUES('39','Assistant Accountant','0');
INSERT INTO `positions` VALUES('40','Head of Finance and Administration','0');
INSERT INTO `positions` VALUES('41','Technical Services Manager','0');
INSERT INTO `positions` VALUES('42','Business Development Cordinator','0');
INSERT INTO `positions` VALUES('43','ICT Manager','0');
INSERT INTO `positions` VALUES('44','Projects Officer','0');
INSERT INTO `positions` VALUES('45','Head of Cooperatives Development and Projects','0');
INSERT INTO `positions` VALUES('46','Marketing and Corporate Executive','0');
INSERT INTO `positions` VALUES('47','GENERAL MANAGER','19');
INSERT INTO `positions` VALUES('48','FINANCE MANAGER','19');
INSERT INTO `positions` VALUES('49','BUSINESS DEVELOPMENT MANAGER','19');
INSERT INTO `positions` VALUES('50','FINANCE MANAGER','19');
INSERT INTO `positions` VALUES('51','HR MANAGER','19');
INSERT INTO `positions` VALUES('52','IT MANAGER','19');
INSERT INTO `positions` VALUES('53','ICT Officer','9');
INSERT INTO `positions` VALUES('54','Accountant','9');
INSERT INTO `positions` VALUES('55','Manager','18');
INSERT INTO `positions` VALUES('56','Accountant','18');
INSERT INTO `positions` VALUES('57','IT Officer','18');
INSERT INTO `positions` VALUES('58','Member Service Officer','18');
INSERT INTO `positions` VALUES('59','INFORMATION TECHNOLOGY OFFICER','17');
INSERT INTO `positions` VALUES('60','ACCOUNTANT','17');
INSERT INTO `positions` VALUES('61','MEMBER SERVICE OFFICER','17');
INSERT INTO `positions` VALUES('62','MANAGER','17');
INSERT INTO `positions` VALUES('63','CASHIER','17');
INSERT INTO `positions` VALUES('64','OFFICE ASSISTANT','17');
INSERT INTO `positions` VALUES('65','CFF Manager','0');
INSERT INTO `positions` VALUES('66','IT OFFICER','20');
INSERT INTO `positions` VALUES('67','ACCOUNTANT','20');
INSERT INTO `positions` VALUES('68','MANAGER','20');
INSERT INTO `positions` VALUES('69','LOAN OFFICER','20');
INSERT INTO `positions` VALUES('70','Business Development Officer','12');
INSERT INTO `positions` VALUES('71','General Manager','9');
INSERT INTO `positions` VALUES('72','Member Services Officer','9');
INSERT INTO `positions` VALUES('73','Accounts Assistant','18');
DROP TABLE IF EXISTS `products`;

CREATE TABLE `products` (
  `product_id` int(11) NOT NULL AUTO_INCREMENT,
  `product` varchar(1028) NOT NULL,
  PRIMARY KEY (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `products` VALUES('2','Aspect 360');
INSERT INTO `products` VALUES('3','Sage 50 Accounts');
INSERT INTO `products` VALUES('4','Fin Financials');
INSERT INTO `products` VALUES('5','eFix Help Desk');
INSERT INTO `products` VALUES('6','ClickIT');
INSERT INTO `products` VALUES('7','Microsoft Word');
DROP TABLE IF EXISTS `public_holidays`;

CREATE TABLE `public_holidays` (
  `holiday_id` int(11) NOT NULL AUTO_INCREMENT,
  `fy_id` int(11) NOT NULL,
  `holiday` varchar(128) NOT NULL,
  `date` date NOT NULL,
  PRIMARY KEY (`holiday_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `public_holidays` VALUES('2','7','Martyrs&apos; Day','2026-03-03');
INSERT INTO `public_holidays` VALUES('3','7','Good Friday','2026-04-03');
INSERT INTO `public_holidays` VALUES('4','7','Easter Monday','2026-04-06');
DROP TABLE IF EXISTS `sacco`;

CREATE TABLE `sacco` (
  `sacco_id` int(11) NOT NULL AUTO_INCREMENT,
  `sacco_name` varchar(1028) NOT NULL,
  `registered_date` date NOT NULL,
  `location` varchar(128) NOT NULL,
  `phone_number` varchar(32) NOT NULL,
  `email_address` varchar(32) NOT NULL,
  `physical_address` text NOT NULL,
  `sacco_president` varchar(32) NOT NULL,
  `assets` double NOT NULL,
  `shares` double NOT NULL,
  `deposits` double NOT NULL,
  `profits` double NOT NULL,
  `loans` double NOT NULL,
  `male_membership` int(11) DEFAULT NULL,
  `female_membership` int(11) DEFAULT NULL,
  `youth_membership` int(11) DEFAULT NULL,
  `other_membership` int(11) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  `logo` varchar(62) DEFAULT NULL,
  PRIMARY KEY (`sacco_id`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `sacco` VALUES('2','UCSS','2000-01-01','Mzuzu','','kmunthali@ucssacco.com','Mzuzu','Sanderson Nyambwani','0','0','0','0','0','0','0','0','0','2024-01-12 02:51:55','');
INSERT INTO `sacco` VALUES('3','MUDI','2000-01-01','Blantyre','0995260987','cchikonga@mudisaccomw.com','Chichiri','Treza','0','0','0','0','0','0','0','0','0','2024-01-12 06:38:47','');
INSERT INTO `sacco` VALUES('4','SUCOMA','2000-01-01','Chikhwawa','0999446684','schongwe@ssacco.mw','Private Bag 50 Nchalo','Kacheyo','0','0','0','0','0','0','0','0','0','2024-01-12 06:41:08','');
INSERT INTO `sacco` VALUES('5','Mzinda','2000-01-01','Lilongwe Old Town','','victor2009chiundira@gmail.com','','Max','0','0','0','0','0','0','0','0','0','2024-01-12 06:43:21','');
INSERT INTO `sacco` VALUES('6','Fincoop','2000-01-01','Lilongwe Old Town','','fmwale@fincoopmw.org','Lilongwe','Mbedza','0','0','0','0','0','0','0','0','0','2024-01-12 06:45:18','');
INSERT INTO `sacco` VALUES('7','Kuwala','2000-01-01','Kanengo','','eseyama@ahlsaccomw.com','Kanengo','Munthali','0','0','0','0','0','0','0','0','0','2024-01-12 06:47:01','');
INSERT INTO `sacco` VALUES('8','DWASCO','2000-01-01','Dwangwa','','ronbwalamba@gmail.com','','Bwalamba','0','0','0','0','0','0','0','0','0','2024-01-12 06:48:44','');
INSERT INTO `sacco` VALUES('9','Mchinji Teachers','2000-01-01','Mchinji','','dkamchiliko3@gmail.com','Mchinji','Mangani','0','0','0','0','0','0','0','0','0','2024-01-12 06:50:34','');
INSERT INTO `sacco` VALUES('10','UMODZI','2000-01-01','Lilongwe','','kaputoconrad@gmail.com','Lilongwe','Eliza','0','0','0','0','0','0','0','0','0','2024-01-12 06:58:11','');
INSERT INTO `sacco` VALUES('11','Sunbird','2000-01-01','Blantyre','','osbornemunyamba@gmail.com','Blantyre','Munyamba','0','0','0','0','0','0','0','0','0','2024-01-12 06:59:50','');
INSERT INTO `sacco` VALUES('12','Msilikali','0000-00-00','Lilongwe','','mmsukwa@msilikalisacco.org','Lilongwe','Simwaka','0','0','0','0','0','0','0','0','0','2024-01-12 07:02:42','');
INSERT INTO `sacco` VALUES('13','Limbe Leaf','2000-01-01','Kanengo','','steve.kileta@lltcsacco.mw','Kanengo','A Mtungama','0','0','0','0','0','0','0','0','0','2024-01-12 07:04:29','');
INSERT INTO `sacco` VALUES('14','Polymed','2000-01-01','Blantyre','','chimwemwenhlane@gmail.com','Blantyre','Chimwemwe','0','0','0','0','0','0','0','0','0','2024-01-12 07:09:32','');
INSERT INTO `sacco` VALUES('15','Police','2000-01-01','Lilongwe','','richsliabunya@malawipolicesacco.','Lilongwe','richmond','0','0','0','0','0','0','0','0','0','2024-01-12 07:11:31','');
INSERT INTO `sacco` VALUES('16','Chitukuko','2000-01-01','Lilongwe','','benson.lemani@chitukukosacco.mw','Lilongwe','Vincent','0','0','0','0','0','0','0','0','0','2024-01-12 07:13:41','');
INSERT INTO `sacco` VALUES('17','Rumphi Teachers','2000-01-01','Rumphi','','Rutesacco@yahoo.com','Rumphi','Nehemiah','0','0','0','0','0','0','0','0','0','2024-01-12 07:15:33','');
INSERT INTO `sacco` VALUES('18','Dedza Community Sacco','2000-01-01','Dedza','','enquiries@dedzacsacco.com','Dedza','Josiah Lonjezo','0','0','0','0','0','0','0','0','0','2024-01-12 07:18:47','');
INSERT INTO `sacco` VALUES('19','Mphuzitsi Sacco','2000-01-01','Thyolo','','alexmakalani@gmail.com','Thyolo','Alex','0','0','0','0','0','0','0','0','0','2024-01-12 08:34:30','');
INSERT INTO `sacco` VALUES('20','Tipindule Community SACCO','2000-01-01','Mponela. Dowa','+265 999 31 47 96','atusayemwakhwawa84@gmail.com','Mponela, Super Sink building, plot number 1','Atusaye Mwakhwawa','0','0','0','0','0','0','0','0','0','2024-01-18 02:16:13','');
DROP TABLE IF EXISTS `sacco_members`;

CREATE TABLE `sacco_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sacco_member_id` varchar(60) NOT NULL,
  `first_name` varchar(32) NOT NULL,
  `last_name` varchar(32) NOT NULL,
  `email_address` varchar(128) DEFAULT NULL,
  `phone_number` varchar(32) DEFAULT NULL,
  `department_id` int(11) DEFAULT NULL,
  `position_id` int(11) DEFAULT NULL,
  `sacco_id` int(11) NOT NULL,
  `profile_pic` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `sacco_members` VALUES('2','yR5T2DkBvzwLqiFrS3SRVuXw9TCKoy1','Komani','Munthali','kmunthali@ucssacco.com','0884623501','','','2','');
INSERT INTO `sacco_members` VALUES('3','m2hHPdAu5mKoLysK24uEn8UOr','Chikondi','Chikonga','cchikonga@mudisaccomw.com','0995260987','','','3','');
INSERT INTO `sacco_members` VALUES('4','MttneynnMigFpoyYNbSihU2sNdyEmBkhggrhfmX','Steve','Chongwe','schongwe@ssacco.mw','0999446684','','','4','');
INSERT INTO `sacco_members` VALUES('5','523AaU1HIEFqBTsNA4xTgdLSAaQA7mnv6HDXQpaS1RR','Victor','Chiundira','victor2009chiundira@gmail.com','','','','5','');
INSERT INTO `sacco_members` VALUES('6','JLFCrKCyYY3xYDN1lqOBQWFv','Felix','Mwale','fmwale@fincoopmw.org','','','','6','');
INSERT INTO `sacco_members` VALUES('7','7tw2JoZ2wYoRjHMC0EluCtCCeXhqZXvqQd','Elvis','Seyama','eseyama@ahlsaccomw.com','','','','7','');
INSERT INTO `sacco_members` VALUES('8','AwHg5FMAhCjVaYLzDMhO1Etg7fy8iafV4ZenvND1NKLvfTEhh9beP','Ronald','Bwalamba','ronbwalamba@gmail.com','','','','8','');
INSERT INTO `sacco_members` VALUES('9','L036IvMKLBOqBXld6EYDUYpT1kR4RUitjWPESTBzvf8h0z1DiS9','Dan','Kamchiliko','dkamchiliko3@gmail.com','0881977102','44','53','9','');
INSERT INTO `sacco_members` VALUES('10','SlprCdlwOoVFnlS0','Conrad','Kaputo','kaputoconrad@gmail.com','','','','10','');
INSERT INTO `sacco_members` VALUES('11','pwOx95M7udcHPedeNxmvKor6JzULtDmI7EzNruPoENIWQ3V1VwPFt','Osborne','Munyamba','osbornemunyamba@gmail.com','','','','11','');
INSERT INTO `sacco_members` VALUES('12','NFcetJu5xHz8y31nXhuzetDOpEXeFcoUWB','Moses','Msukwa','msukwamose1@gmail.com','','','','12','');
INSERT INTO `sacco_members` VALUES('13','9TJKJeX2Kb','Steve','Kileta','steve.kileta@lltcsacco.mw','','','','13','');
INSERT INTO `sacco_members` VALUES('14','A9Oaf0niIBmbvheIgm4di','Chimwemwe','Nhlane','chimwemwenhlane@gmail.com','','','','14','');
INSERT INTO `sacco_members` VALUES('15','8LBD','Richmond','Liabunya','richsliabunya@malawipolicesacco.com','','','','15','');
INSERT INTO `sacco_members` VALUES('16','ZTbXBSsWNM3RG39Ez7GhrTT47H45OHSLto8pbeNeX6ig','Benson','Lemani','benson.lemani@chitukukosacco.mw','','','','16','');
INSERT INTO `sacco_members` VALUES('17','aPfzoSuGN2tXhlnCXSmQq62Xg4M3atf8UdMPfRNl5r9kNXHJluoBwJj4','NEHEMIAH','NG&apos;ANJO','nehemiahtk@yahoo.com','0997082156','51','59','17','');
INSERT INTO `sacco_members` VALUES('18','xJjYpUTNT7JNk0mu2rySeBrQMH7dHKp6JtB80','John','Makhuwira','jmakhuwira@dedzacsacco.com','+265999000687','49','57','18','');
INSERT INTO `sacco_members` VALUES('19','09CUBwoQM72V5Ovonl2Beys2K','Alex','Makalani','alexmakalani@gmail.com','','','','19','');
INSERT INTO `sacco_members` VALUES('20','u5w2Fy8NC','JAMES PATRICK','TEMBO','jamesptembo@gmail.com','0999527400','46','47','19','');
INSERT INTO `sacco_members` VALUES('21','54VZavXRk2GCN25KAlWA','Lonjezo','Josiah','ljosiah@dedzacsacco.com','+265 995 496 135','47','55','18','');
INSERT INTO `sacco_members` VALUES('22','yoZlRYnVk','Felllie','Mkandawire','fmkandawire@dedzacsacco.com','+265996429655','48','56','18','');
INSERT INTO `sacco_members` VALUES('23','Jh5ud','THOMAS','CHIRWA','','0997826790','54','61','17','');
INSERT INTO `sacco_members` VALUES('24','junKd1hApKfstKKS','Blessings','Banda','bandablessings@tipindulesacco.com','0884212749','57','66','20','');
INSERT INTO `sacco_members` VALUES('25','BTEAfn2AXMgA8gbZvXjH','ULEMU','KUMWENDA','rutesacco@yahoo.com','0998839298','53','62','17','');
INSERT INTO `sacco_members` VALUES('26','NjNU9IT0RWwhQEZIylKSlwCZPtRCMfqGb5lCwLiYKKAcS','Atusaye','Mwakhwawa','atusayemwakhwawa84@gmail.com','0999314796','55','68','20','');
INSERT INTO `sacco_members` VALUES('27','iW0uM4s7U5nSDHB2yz0OOgO8MTUmZx6rp7VHfprSkGl9tTW38vXEe','Taonga','Mughandira','taongamughandira@tipindulesacco.com','0993153528','56','67','20','');
INSERT INTO `sacco_members` VALUES('28','tKkgrGd1vF8RyPQsjL','Naomi','Msowoya','nmsowoya@msilikalisacco.org','','59','70','12','');
INSERT INTO `sacco_members` VALUES('29','1t3sZbUb7YaNjKYnzguCKAjdQph','Moses','Mombera','momberamoses@gmail.com','0999726170','45','54','9','');
INSERT INTO `sacco_members` VALUES('30','3r14QVBU6zJNPD','Jennipher','Munthali  Nkhandwe','','0998839596','52','60','17','');
INSERT INTO `sacco_members` VALUES('31','syNsOoMXSWcO','Goodson','Nyirenda','','0995831123','52','63','17','');
INSERT INTO `sacco_members` VALUES('32','yMgrDWshKcr8k','Wezzie','Maudzu','','0888020004','48','73','18','');
DROP TABLE IF EXISTS `system_users`;

CREATE TABLE `system_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `member_id` varchar(60) NOT NULL,
  `username` varchar(32) NOT NULL,
  `password` varchar(128) NOT NULL,
  `user_role` int(11) NOT NULL DEFAULT 0,
  `member_of` int(11) NOT NULL DEFAULT 0,
  `account_status` int(11) NOT NULL DEFAULT 0,
  `login_trials` int(11) NOT NULL DEFAULT 0,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1006108 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `system_users` VALUES('1','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','chawe','3be9c018356ac60fa7bcbc5a6c5ad6136ef295c9','0','0','1','0','2023-06-15 08:24:56');
INSERT INTO `system_users` VALUES('64','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','dimfa','cd8f375eec2074249f8369c27b9fde47568570c7','0','0','1','0','2023-11-23 09:22:33');
INSERT INTO `system_users` VALUES('65','kK7QbehdzIBdqAIGt1p','alex','d9a81a222430a2649785c1983f03c022280358b4','1','1','1','0','2023-11-27 04:57:29');
INSERT INTO `system_users` VALUES('66','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','Amang&apos;anya','cd8f375eec2074249f8369c27b9fde47568570c7','2','0','1','0','2023-11-27 09:25:12');
INSERT INTO `system_users` VALUES('67','havCLHBjolrH5wI6cnP3UyAqHKvS3kC6thavU4pD8vW0qh0vuJCTYGDU','bzikomakuka','b3450d482ec10dd67dccd5e1effe5c9b4b3fe458','0','0','1','0','2023-12-19 01:11:54');
INSERT INTO `system_users` VALUES('68','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','lbanda','5cf3072ede0a15d76d07b9735dc4d10b3d596562','2','0','1','0','2023-12-19 01:17:49');
INSERT INTO `system_users` VALUES('69','cN7XJK4EJgIcFZ3P4pL','ekaziona','92cbbac9692761563646c489c561e6bb79ef8b1d','2','0','1','0','2023-12-19 01:32:48');
INSERT INTO `system_users` VALUES('70','2RVXn9PK7tg7wFGwK9hvJtfc6LkDbLRg00','amakuluni','51af07629187a9a891e33acd97d098baaee16da6','2','0','1','0','2023-12-19 01:37:39');
INSERT INTO `system_users` VALUES('71','vRrjIqmw9m5lM4sorbq7R2','tyambani','f1066ee9401b1151126a0e0f12a6d5ff64e30206','2','0','1','0','2023-12-19 01:41:37');
INSERT INTO `system_users` VALUES('72','2nK9f2qboFJYiMJcJoTWQXccS6TcrtKtX8I','mnkhoma','1b5cd4d7c30aa09afa595bff837e11c62e738532','2','0','1','0','2023-12-19 01:44:03');
INSERT INTO `system_users` VALUES('73','lTYqrrnO3Qpi4Q','plunda','07bcd2e169eab584c83636250d3b248df34d1b1b','2','0','1','0','2023-12-19 01:47:14');
INSERT INTO `system_users` VALUES('74','FtFFeM1Yb17UWcqIqodm4csT','rchalendewa','3fe901a06ff5acfd53dc19bbfa3f99a2776d4bee','2','0','1','0','2023-12-19 01:52:19');
INSERT INTO `system_users` VALUES('75','inAJsQeZy13r6c5xRI8i0','kmulewa','75a72f213bae64b13a790edf9a9b85781499ea8b','2','0','1','0','2023-12-19 02:21:25');
INSERT INTO `system_users` VALUES('76','RWM9poiBTms','fnyangulu','0c1abdff49c779349a26e19a8040383bfa2917ec','2','0','1','0','2023-12-19 02:26:45');
INSERT INTO `system_users` VALUES('77','IIXiuVLQbocEsCBidtKrqGQl6WtTm','bnaphazi','6483a8c304dbbc03948f50d5c6e63318406a3cb6','2','0','1','0','2023-12-19 03:49:33');
INSERT INTO `system_users` VALUES('78','QWiEBixN9WstbEGkqEvp','ethindwa','2658f300643f9ca1adb5721921d024e8bb972038','0','0','1','0','2023-12-19 07:38:40');
INSERT INTO `system_users` VALUES('79','aOTFPSYcTJxGpjfq5xhLRJMZwZa','pchikhula','22c9a2698e7175d5a0f897f0b3d9c1fbf0913a07','2','0','1','0','2023-12-19 08:44:49');
INSERT INTO `system_users` VALUES('80','dYN9VwdDjjomFjekCG1C8ZtKcDSO3jLYjWYGGy','shara','81174083ab8c352eb0c06d2d58c79ea1e87c80df','2','0','0','0','2023-12-19 08:52:53');
INSERT INTO `system_users` VALUES('81','CIEpGhsSbm9rgwakucQ8aIH3Ju7WhSbr0lkYBBfShg0jcQHob','danimfa','a5d0426a8ddeb3e02cb30652138b86b37cafafd9','4','999','1','0','2023-12-19 09:06:25');
INSERT INTO `system_users` VALUES('82','ZC2UrkGa5cobAdVmgWVPXEDb0th6FlcgV','cduwe','281e78800aebb63d1ebe22c5c17a76074594a1b0','2','0','1','0','2023-12-22 05:48:39');
INSERT INTO `system_users` VALUES('83','YS3870fdsPY1LhX304','ochikhasu','bb53976751ed10b74154236c86089c28e8d7e8c3','2','0','1','0','2024-01-08 04:00:32');
INSERT INTO `system_users` VALUES('84','yR5T2DkBvzwLqiFrS3SRVuXw9TCKoy1','kmunthali','216ac829305630965728b425186a390c20663976','1','2','1','0','2024-01-12 02:51:55');
INSERT INTO `system_users` VALUES('85','m2hHPdAu5mKoLysK24uEn8UOr','cchikonga','9d2dacada571b4e3e78ecf355907a900549b976d','1','3','0','0','2024-01-12 06:38:47');
INSERT INTO `system_users` VALUES('86','MttneynnMigFpoyYNbSihU2sNdyEmBkhggrhfmX','schongwe','81174083ab8c352eb0c06d2d58c79ea1e87c80df','1','4','0','0','2024-01-12 06:41:08');
INSERT INTO `system_users` VALUES('87','523AaU1HIEFqBTsNA4xTgdLSAaQA7mnv6HDXQpaS1RR','vchiundira','dd20d179560f80c671911ac2012aa04d9da4831a','1','5','0','0','2024-01-12 06:43:21');
INSERT INTO `system_users` VALUES('88','JLFCrKCyYY3xYDN1lqOBQWFv','fmwale','a4840b2fdb5fe80a609934cdb60d1e3252f7007f','1','6','0','0','2024-01-12 06:45:18');
INSERT INTO `system_users` VALUES('89','7tw2JoZ2wYoRjHMC0EluCtCCeXhqZXvqQd','eseyama','0a43fd2dd8f0530c7344901821ef8baa113fc4e1','1','7','1','0','2024-01-12 06:47:01');
INSERT INTO `system_users` VALUES('90','AwHg5FMAhCjVaYLzDMhO1Etg7fy8iafV4ZenvND1NKLvfTEhh9beP','rbwalamba','84e3d2bba7d1229f0392f66c55988b358f0ce90e','1','8','0','0','2024-01-12 06:48:44');
INSERT INTO `system_users` VALUES('91','L036IvMKLBOqBXld6EYDUYpT1kR4RUitjWPESTBzvf8h0z1DiS9','dkamchiliko','08610015a708985b0a771a85446e047490356001','1','9','1','0','2024-01-12 06:50:34');
INSERT INTO `system_users` VALUES('92','SlprCdlwOoVFnlS0','ckaputo','39e1527d59e3d460c3efa938d459a4fed5c15a5f','1','10','1','0','2024-01-12 06:58:11');
INSERT INTO `system_users` VALUES('93','pwOx95M7udcHPedeNxmvKor6JzULtDmI7EzNruPoENIWQ3V1VwPFt','omunyamba','4f4fc10fcc72214f3287c7f014a7ac7236b61d36','1','11','0','0','2024-01-12 06:59:50');
INSERT INTO `system_users` VALUES('94','NFcetJu5xHz8y31nXhuzetDOpEXeFcoUWB','mmsukwa','0af24f5f489bb0acb4159525da7a780711e52039','1','12','1','0','2024-01-12 07:02:42');
INSERT INTO `system_users` VALUES('95','9TJKJeX2Kb','skileta','81174083ab8c352eb0c06d2d58c79ea1e87c80df','1','13','0','0','2024-01-12 07:04:29');
INSERT INTO `system_users` VALUES('96','A9Oaf0niIBmbvheIgm4di','cnhlane','9d2dacada571b4e3e78ecf355907a900549b976d','1','14','0','0','2024-01-12 07:09:32');
INSERT INTO `system_users` VALUES('97','8LBD','rliabunya','4eb2d757c63c12a71dcba492e7c2e7645b238a43','1','15','1','0','2024-01-12 07:11:31');
INSERT INTO `system_users` VALUES('98','ZTbXBSsWNM3RG39Ez7GhrTT47H45OHSLto8pbeNeX6ig','blemani','a108969f8c1ab132c9194d314ddfb7b4fef41f3f','1','16','1','0','2024-01-12 07:13:41');
INSERT INTO `system_users` VALUES('99','aPfzoSuGN2tXhlnCXSmQq62Xg4M3atf8UdMPfRNl5r9kNXHJluoBwJj4','nng&apos;anjo','8f90915f572b216ece0a34a8a8fe3bab8a3fde6a','1','17','1','0','2024-01-12 07:15:33');
INSERT INTO `system_users` VALUES('100','xJjYpUTNT7JNk0mu2rySeBrQMH7dHKp6JtB80','jmakhuwira','37dba9267b6aaa63c3d0c2cf29530d0a1dcfab21','1','18','1','0','2024-01-12 07:18:47');
INSERT INTO `system_users` VALUES('101','09CUBwoQM72V5Ovonl2Beys2K','amakalani','900724ba8cbc6fd62f66caf5e0428ec4594c7524','1','19','1','0','2024-01-12 08:34:30');
INSERT INTO `system_users` VALUES('102','u5w2Fy8NC','jtembo','2470d1e47843c136b3a638ae9e2876758c036fa3','3','19','0','0','2024-01-12 09:44:04');
INSERT INTO `system_users` VALUES('103','54VZavXRk2GCN25KAlWA','ljosiah','a0412a4f52a94f9724d59f74811c786c05928bc2','3','18','1','0','2024-01-12 12:40:06');
INSERT INTO `system_users` VALUES('104','yoZlRYnVk','fmkandawire','4b81a782b85c61fe55823602b117e607f7b462cd','3','18','1','0','2024-01-12 12:43:17');
INSERT INTO `system_users` VALUES('105','Jh5ud','tchirwa','d7625342aa52aab98f50b15bf409ddb68d548a77','3','17','0','0','2024-01-15 06:07:03');
INSERT INTO `system_users` VALUES('107','junKd1hApKfstKKS','bbanda','707dc325d5fc16e319c63f918c18ec0c719211cd','1','20','1','0','2024-01-18 02:16:13');
INSERT INTO `system_users` VALUES('108','BTEAfn2AXMgA8gbZvXjH','ukumwenda','d06c93014f547c2f0b002dce307f566b53e5ef79','3','17','0','0','2024-01-18 02:59:27');
INSERT INTO `system_users` VALUES('109','NjNU9IT0RWwhQEZIylKSlwCZPtRCMfqGb5lCwLiYKKAcS','amwakhwawa','010e50f440c9d96061f7e339ff8cd632debedfdb','3','20','0','0','2024-01-24 05:36:49');
INSERT INTO `system_users` VALUES('110','iW0uM4s7U5nSDHB2yz0OOgO8MTUmZx6rp7VHfprSkGl9tTW38vXEe','tmughandira','69e3295de58c695f07d0a8b6a6a268b26c481a1d','3','20','1','0','2024-01-24 05:41:41');
INSERT INTO `system_users` VALUES('111','tKkgrGd1vF8RyPQsjL','nmsowoya','6cc4eba272f8d3cfa2a3fd07d53c7631283aeb72','3','12','0','0','2024-02-02 03:41:56');
INSERT INTO `system_users` VALUES('112','1t3sZbUb7YaNjKYnzguCKAjdQph','mmombera7355','e5fb192d7dae0f7218a47213e14ebde40d3ac5ed','3','9','1','0','2024-02-08 09:46:23');
INSERT INTO `system_users` VALUES('1006098','sxe100','owen','ce9592438d06a9fb121b534a1ce1eecd64058779','0','0','1','0','2024-05-02 05:45:06');
INSERT INTO `system_users` VALUES('1006099','','','ce9592438d06a9fb121b534a1ce1eecd64058779','0','0','0','0','2024-05-02 05:45:06');
INSERT INTO `system_users` VALUES('1006100','3kfqGBPLsb7vRjg05zQSANue9V1','owen','2972d945814fe91ee9848e1ca3c9569c4df8d635','2','0','1','0','2024-05-02 06:29:42');
INSERT INTO `system_users` VALUES('1006101','3r14QVBU6zJNPD','nng&apos;anjo','8f90915f572b216ece0a34a8a8fe3bab8a3fde6a','3','17','0','0','2024-05-13 03:48:13');
INSERT INTO `system_users` VALUES('1006102','syNsOoMXSWcO','nng&apos;anjo','8f90915f572b216ece0a34a8a8fe3bab8a3fde6a','3','17','0','0','2024-05-13 03:52:25');
INSERT INTO `system_users` VALUES('1006103','yMgrDWshKcr8k','Wmaudzu','e5242aaa09bc2048f8b0b4f0f6854db909d87ffa','3','18','0','0','2024-12-19 08:50:37');
INSERT INTO `system_users` VALUES('1006104','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','test','b9c6a46d4765b22f5c66b140c0b177a23f72cf7f','2','0','1','0','2026-02-06 09:41:17');
INSERT INTO `system_users` VALUES('1006105','m2qYOyqKVKErImdlwCImuwgg','martha','381c43fe6d171a3bae6344162b53b7c9cc6a7072','2','0','1','0','2026-02-06 13:55:32');
INSERT INTO `system_users` VALUES('1006106','IDauGul','Gerald','381c43fe6d171a3bae6344162b53b7c9cc6a7072','2','0','0','0','2026-02-06 13:57:07');
INSERT INTO `system_users` VALUES('1006107','rsxQhzblS7LK6ErYLILFVUUxNbULOwlapGTu70Qn6kaJn8UqtgbUtXOQYX','mwayi','cd8f375eec2074249f8369c27b9fde47568570c7','2','0','0','0','2026-02-07 02:00:03');
DROP TABLE IF EXISTS `ticket_categories`;

CREATE TABLE `ticket_categories` (
  `ticket_category_id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_category` varchar(1028) NOT NULL,
  PRIMARY KEY (`ticket_category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `ticket_categories` VALUES('1','Software');
INSERT INTO `ticket_categories` VALUES('2','Hardware');
DROP TABLE IF EXISTS `ticket_response`;

CREATE TABLE `ticket_response` (
  `response_id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) NOT NULL,
  `member_id` varchar(60) NOT NULL,
  `response` text NOT NULL,
  `date` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`response_id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `ticket_response` VALUES('1','2','m2qYOyqKVKErImdlwCImuwgg','ok','2026-02-06 14:06:58');
INSERT INTO `ticket_response` VALUES('2','2','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','ok','2026-02-06 14:16:31');
INSERT INTO `ticket_response` VALUES('3','2','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','ok','2026-02-06 14:16:31');
INSERT INTO `ticket_response` VALUES('4','2','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','Please simply restart the PC','2026-02-07 00:51:42');
INSERT INTO `ticket_response` VALUES('5','3','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','ok check do this and that','2026-02-07 01:00:19');
DROP TABLE IF EXISTS `tickets`;

CREATE TABLE `tickets` (
  `ticket_id` int(11) NOT NULL AUTO_INCREMENT,
  `posted_by` varchar(60) NOT NULL,
  `ticket_title` varchar(1028) NOT NULL,
  `ticket_description` text NOT NULL,
  `ticket_category` int(11) NOT NULL,
  `ticket_product` int(11) NOT NULL,
  `ticket_priority` int(11) NOT NULL DEFAULT 0,
  `ticket_attachment` varchar(60) DEFAULT NULL,
  `ticket_referred` int(11) NOT NULL DEFAULT 0,
  `date_referred` datetime DEFAULT NULL,
  `date_closed` datetime DEFAULT NULL,
  `date_opened` timestamp NOT NULL DEFAULT current_timestamp(),
  `closing_remarks` text DEFAULT NULL,
  `ticket_status` int(11) NOT NULL DEFAULT 0,
  `member_of` int(11) NOT NULL,
  `ticket_progress` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ticket_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `tickets` VALUES('2','m2qYOyqKVKErImdlwCImuwgg','PC issues','help pliz','2','6','1','1784996100_1770404656.jpg','0','','','2026-02-06 14:04:16','','0','0','100');
INSERT INTO `tickets` VALUES('3','m2qYOyqKVKErImdlwCImuwgg','PC not booting','ok','2','6','3','1671813789_1770404788.jpg','0','','','2026-02-06 14:06:28','','0','0','50');
DROP TABLE IF EXISTS `travel_advance_liquidations`;

CREATE TABLE `travel_advance_liquidations` (
  `liquidation_id` int(11) NOT NULL AUTO_INCREMENT,
  `travel_advance_id` varchar(80) NOT NULL,
  `liq_logistics` int(11) NOT NULL,
  `liq_nights` int(11) NOT NULL,
  `liq_mileage` double NOT NULL,
  `liq_fuel` double NOT NULL,
  `liq_day_meal` double NOT NULL,
  `liq_other` varchar(1028) DEFAULT NULL,
  `liq_other_amount` double NOT NULL DEFAULT 0,
  `liq_receipts` varchar(128) NOT NULL,
  `total_liquidation` double NOT NULL,
  `balance_overage` double NOT NULL,
  `liq_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `liq_status` int(11) NOT NULL DEFAULT 0,
  `liq_approved_by` varchar(60) DEFAULT NULL,
  `liq_date_approved` date DEFAULT NULL,
  `liq_approval_remarks` text DEFAULT NULL,
  PRIMARY KEY (`liquidation_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `travel_advance_liquidations` VALUES('1','177039529672xPMrexshdiQEchOH8Mw','2','9','650','1','22500','Fuel','10000','177039529672xPMrexshdiQEchOH8Mw_1770396196.jpg','975210','-15670','2026-02-06 11:43:16','1','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-06','No problem');
DROP TABLE IF EXISTS `travel_advance_request`;

CREATE TABLE `travel_advance_request` (
  `advance_id` int(11) NOT NULL AUTO_INCREMENT,
  `travel_advance_id` varchar(128) NOT NULL,
  `employee_id` varchar(60) NOT NULL,
  `pillar` int(11) NOT NULL,
  `purpose` text NOT NULL,
  `logistics` varchar(128) NOT NULL,
  `nights` int(11) NOT NULL,
  `rate` double NOT NULL,
  `day_meal` double NOT NULL,
  `mileage` double DEFAULT 0,
  `total_fuel` double DEFAULT 0,
  `fuel` varchar(11) DEFAULT NULL,
  `fuel_price` double DEFAULT 0,
  `total_budget` double DEFAULT NULL,
  `date_posted` timestamp NOT NULL DEFAULT current_timestamp(),
  `checked_by` varchar(60) DEFAULT NULL,
  `date_checked` date DEFAULT NULL,
  `checker_note` text DEFAULT NULL,
  `approved_by` varchar(60) DEFAULT NULL,
  `date_approved` date DEFAULT NULL,
  `approver_note` text DEFAULT NULL,
  `request_status` int(11) NOT NULL DEFAULT 1,
  `own_days` int(11) NOT NULL DEFAULT 0,
  `own_rate` double NOT NULL DEFAULT 0,
  `tollgate_fees` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`advance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `travel_advance_request` VALUES('2','1704716776R0fzjrIBKcIt0gJ2DvpVeb95J','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','4','SDP Facilitation','2','5','35000','10000','1000','192000','1','1920','377000','2024-01-08 07:34:37','','','','inAJsQeZy13r6c5xRI8i0','2024-01-24','ok','99','0','0','0');
INSERT INTO `travel_advance_request` VALUES('3','17047168284UoUpF78B5cgVZzw1JrheEEfMwMlel308DUk','YS3870fdsPY1LhX304','4','SDB facilitation','2','3','30000','8000','800','139680','2','1746','237680','2024-01-08 07:37:17','','','','inAJsQeZy13r6c5xRI8i0','2024-01-24','ok','99','0','0','0');
INSERT INTO `travel_advance_request` VALUES('4','1705912856BOMQD2uVahIaxu4ct0kr4cIlXf2qJF4D7JgotKIl5FjixZs9','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','4','Statistics Consolidation','2','5','60000','15000','0','0','','0','319000','2024-01-22 03:47:22','','','','inAJsQeZy13r6c5xRI8i0','2024-01-24','ok','99','0','0','4000');
INSERT INTO `travel_advance_request` VALUES('5','1706079573CPDQP5T7','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','4','Attending Meeting with Chapter 1 SACCOs on Price Increase by MFI-Hub','2','1','60000','15000','700','177100','2','2530','256100','2024-01-24 01:59:39','','','','kaiyO9EDlWPzNvHGcAnuocexySbkGjr8Wv1kH9WksY3iAEEAok','2024-01-24','This is approved','2','0','0','4000');
INSERT INTO `travel_advance_request` VALUES('6','1706085740r49gokzK1gC7ran2lK65zPyQORR255o5j9ZbMvnJuZT22DC2','inAJsQeZy13r6c5xRI8i0','3','chapter meeting','2','2','85000','22500','1000','273400','1','2734','471900','2024-01-24 03:49:07','','','','','','','1','0','0','6000');
INSERT INTO `travel_advance_request` VALUES('7','177039529672xPMrexshdiQEchOH8Mw','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','1','Training of trainers','2','9','85000','22500','600','164040','1','2734','959540','2026-02-06 11:32:48','','','','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-06','No problem','5','0','0','8000');
DROP TABLE IF EXISTS `vehicle_requests`;

CREATE TABLE `vehicle_requests` (
  `request_id` int(11) NOT NULL AUTO_INCREMENT,
  `requested_by` varchar(60) NOT NULL,
  `date_requested` timestamp NOT NULL DEFAULT current_timestamp(),
  `driver_name` varchar(128) NOT NULL,
  `activity_name` varchar(1028) NOT NULL,
  `date_from` date NOT NULL,
  `date_to` date NOT NULL,
  `destination` varchar(128) DEFAULT NULL,
  `departure_from` varchar(128) NOT NULL,
  `days` int(11) DEFAULT NULL,
  `vehicle_assigned` varchar(128) DEFAULT NULL,
  `open_mileage` double DEFAULT NULL,
  `close_mileage` double DEFAULT NULL,
  `fuel_level` varchar(32) DEFAULT NULL,
  `tools` varchar(128) DEFAULT NULL,
  `dents` varchar(32) DEFAULT NULL,
  `spare_tyre` varchar(32) DEFAULT NULL,
  `cleanliness` varchar(32) DEFAULT NULL,
  `checked_by` varchar(60) DEFAULT NULL,
  `authorized_by` varchar(60) DEFAULT NULL,
  `received_by` varchar(60) DEFAULT NULL,
  `date_checked` date DEFAULT NULL,
  `date_authorized` date DEFAULT NULL,
  `date_received` date DEFAULT NULL,
  `request_status` int(11) NOT NULL DEFAULT 0,
  `authorize_remarks` varchar(1028) DEFAULT NULL,
  `return_fuel_level` varchar(32) DEFAULT NULL,
  `fuel_used` double DEFAULT NULL,
  `return_distance_covered` double DEFAULT NULL,
  `return_cleanliness` varchar(32) DEFAULT NULL,
  `return_tools` varchar(128) DEFAULT NULL,
  `return_spare_tyre` varchar(32) DEFAULT NULL,
  `return_dents` varchar(32) DEFAULT NULL,
  `distance_covered` double DEFAULT NULL,
  `return_remarks` text DEFAULT NULL,
  `date_returned` date DEFAULT NULL,
  PRIMARY KEY (`request_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;
INSERT INTO `vehicle_requests` VALUES('1','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2026-02-04 18:03:07','Zimba','Training','2026-02-13','2026-02-20','Blantyre','Lilongwe','','','','','','','','','','','','','','','','0','','','','','','','','','','','');
INSERT INTO `vehicle_requests` VALUES('2','sac8zAqp78dA4SMUpI9kNzqiPRoh4tQuAahBfdMh','2026-02-04 18:05:13','Peter Jere','Operationalisation of Staff Portal','2026-02-23','2026-02-26','Lilongwe','Blantyre','','DZ7331','20000','','Full',' Jack Triangle Plates Ropes','N/A','Available','Not Clean','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','','2026-02-07','2026-02-05','','2','ok','','','','','','','','','','');
INSERT INTO `vehicle_requests` VALUES('3','4q2KeXsTWaSTE3zTi1c2PVlysPNZ0FfNH8hcNid7d02jpLEfalhI6','2026-02-06 11:24:49','Owen Banda','Training','2026-02-09','2026-02-09','Lirangwe','Blantyre','','','','','','','','','','','','','','','','0','','','','','','','','','','','');
INSERT INTO `vehicle_requests` VALUES('4','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2026-02-07 07:11:15','John Zimba','Training','2026-02-07','2026-02-14','Lilongwe','Blantyre','','','','','','','','','','','','','','','','0','','','','','','','','','','','');
INSERT INTO `vehicle_requests` VALUES('5','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','2026-02-07 07:19:11','Owen Banda','Training','2026-02-08','2026-02-14','Salima','Blantyre','','','','','','','','','','','','','','','','0','','','','','','','','','','','');
INSERT INTO `vehicle_requests` VALUES('6','IFZGIRALUJuOJ7iqPs1k25x9Kz9ZyGiv1ZNsv3','2026-02-07 07:21:33','Gilbert Nkhata','School of Commerce','2026-02-08','2026-02-09','Tedzani','Lilongwe','','DZ7331','20000','','Full',' Jack Triangle Plates','N/A','Available','Very Clean','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','','2026-02-07','2026-02-07','2026-02-07','3','Authorised','','','','','','','','','','');
INSERT INTO `vehicle_requests` VALUES('7','m2qYOyqKVKErImdlwCImuwgg','2026-02-07 07:35:19','Manson Jere','Training','2026-02-14','2026-02-14','Salima','Lilongwe','','DZ7331','20000','','Full',' Jack','N/A','N/A','Very Clean','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','pdFuRqCJqUjmbdEHQmcDzKi5VyYvZfkeG3CW7KbxuhAc6hk4yF9O16ZNFl','','2026-02-07','2026-02-07','2026-02-07','3','ok','','','','','','','','','','');


COMMIT;